/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.user;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.auth.user.IUserAccessor;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.IOUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileUserAccessor
implements IUserAccessor {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileUserAccessor.class);
    private static final String TEMP_SUFFIX = ".temp";
    private static final String STRING_ENCODING = "utf-8";
    private static final String userSnapshotFileName = "system" + File.separator + "users";
    private String userDirPath;
    private ThreadLocal<ByteBuffer> encodingBufferLocal = new ThreadLocal();
    private ThreadLocal<byte[]> strBufferLocal = new ThreadLocal();

    public LocalFileUserAccessor(String userDirPath) {
        this.userDirPath = userDirPath;
    }

    /*
     * Exception decompiling
     */
    @Override
    public User loadUser(String username) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUser(User user) throws IOException {
        File userProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + user.getName() + ".profile" + TEMP_SUFFIX);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(userProfile));){
            try {
                IOUtils.writeString(outputStream, user.getName(), STRING_ENCODING, this.encodingBufferLocal);
                IOUtils.writeString(outputStream, user.getPassword(), STRING_ENCODING, this.encodingBufferLocal);
                user.getPrivilegeList().sort(PathPrivilege.REFERENCE_DESCENT_SORTER);
                int privilegeNum = user.getPrivilegeList().size();
                IOUtils.writeInt(outputStream, privilegeNum, this.encodingBufferLocal);
                for (int i = 0; i < privilegeNum; ++i) {
                    PathPrivilege pathPrivilege = user.getPrivilegeList().get(i);
                    IOUtils.writePathPrivilege(outputStream, pathPrivilege, STRING_ENCODING, this.encodingBufferLocal);
                }
                int userNum = user.getRoleList().size();
                IOUtils.writeInt(outputStream, userNum, this.encodingBufferLocal);
                for (int i = 0; i < userNum; ++i) {
                    IOUtils.writeString(outputStream, user.getRoleList().get(i), STRING_ENCODING, this.encodingBufferLocal);
                }
                IOUtils.writeInt(outputStream, user.isUseWaterMark() ? 1 : 0, this.encodingBufferLocal);
                outputStream.flush();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        finally {
            this.encodingBufferLocal.remove();
        }
        File oldFile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + user.getName() + ".profile");
        IOUtils.replaceFile(userProfile, oldFile);
    }

    @Override
    public boolean deleteUser(String username) throws IOException {
        File userProfile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + username + ".profile");
        File backFile = SystemFileFactory.INSTANCE.getFile(this.userDirPath + File.separator + username + ".profile" + TEMP_SUFFIX);
        if (!userProfile.exists() && !backFile.exists()) {
            return false;
        }
        if (userProfile.exists() && !userProfile.delete() || backFile.exists() && !backFile.delete()) {
            throw new IOException(String.format("Cannot delete user file of %s", username));
        }
        return true;
    }

    @Override
    public List<String> listAllUsers() {
        File userDir = SystemFileFactory.INSTANCE.getFile(this.userDirPath);
        String[] names = userDir.list((dir, name) -> name.endsWith(".profile") || name.endsWith(TEMP_SUFFIX));
        ArrayList<String> retList = new ArrayList<String>();
        if (names != null) {
            HashSet<String> set = new HashSet<String>();
            for (String fileName : names) {
                set.add(fileName.replace(".profile", "").replace(TEMP_SUFFIX, ""));
            }
            retList.addAll(set);
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        SystemFileFactory systemFileFactory = SystemFileFactory.INSTANCE;
        File userFolder = systemFileFactory.getFile(this.userDirPath);
        File userSnapshotDir = systemFileFactory.getFile(snapshotDir, userSnapshotFileName);
        File userTmpSnapshotDir = systemFileFactory.getFile(userSnapshotDir.getAbsolutePath() + "-" + UUID.randomUUID());
        boolean result = true;
        try {
            result = org.apache.iotdb.commons.utils.FileUtils.copyDir(userFolder, userTmpSnapshotDir);
        }
        finally {
            if (userTmpSnapshotDir.exists() && !userTmpSnapshotDir.delete()) {
                org.apache.iotdb.commons.utils.FileUtils.deleteDirectory(userTmpSnapshotDir);
            }
        }
        return result &= userTmpSnapshotDir.renameTo(userSnapshotDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        SystemFileFactory systemFileFactory = SystemFileFactory.INSTANCE;
        File userFolder = systemFileFactory.getFile(this.userDirPath);
        File userTmpFolder = systemFileFactory.getFile(userFolder.getAbsolutePath() + "-" + UUID.randomUUID());
        File userSnapshotDir = systemFileFactory.getFile(snapshotDir, userSnapshotFileName);
        try {
            FileUtils.moveDirectory((File)userFolder, (File)userTmpFolder);
            if (!org.apache.iotdb.commons.utils.FileUtils.copyDir(userSnapshotDir, userFolder)) {
                logger.error("Failed to load user folder snapshot and rollback.");
                org.apache.iotdb.commons.utils.FileUtils.deleteDirectory(userFolder);
                FileUtils.moveDirectory((File)userTmpFolder, (File)userFolder);
            }
        }
        finally {
            org.apache.iotdb.commons.utils.FileUtils.deleteDirectory(userTmpFolder);
        }
    }

    @Override
    public void reset() {
        if (SystemFileFactory.INSTANCE.getFile(this.userDirPath).mkdirs()) {
            logger.info("user info dir {} is created", (Object)this.userDirPath);
        } else if (!SystemFileFactory.INSTANCE.getFile(this.userDirPath).exists()) {
            logger.error("user info dir {} can not be created", (Object)this.userDirPath);
        }
    }

    @Override
    public String getDirPath() {
        return this.userDirPath;
    }
}

