/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

public enum PrivilegeType {
    SET_STORAGE_GROUP(true),
    INSERT_TIMESERIES(true),
    UPDATE_TIMESERIES(true),
    READ_TIMESERIES(true),
    CREATE_TIMESERIES(true),
    DELETE_TIMESERIES(true),
    CREATE_USER,
    DELETE_USER,
    MODIFY_PASSWORD,
    LIST_USER,
    GRANT_USER_PRIVILEGE,
    REVOKE_USER_PRIVILEGE,
    GRANT_USER_ROLE,
    REVOKE_USER_ROLE,
    CREATE_ROLE,
    DELETE_ROLE,
    LIST_ROLE,
    GRANT_ROLE_PRIVILEGE,
    REVOKE_ROLE_PRIVILEGE,
    CREATE_FUNCTION,
    DROP_FUNCTION,
    CREATE_TRIGGER(true),
    DROP_TRIGGER(true),
    START_TRIGGER(true),
    STOP_TRIGGER(true),
    CREATE_CONTINUOUS_QUERY,
    DROP_CONTINUOUS_QUERY,
    ALL,
    DELETE_STORAGE_GROUP(true);

    private static final int PRIVILEGE_COUNT;
    private final boolean isPathRelevant;

    private PrivilegeType() {
        this.isPathRelevant = false;
    }

    private PrivilegeType(boolean isPathRelevant) {
        this.isPathRelevant = isPathRelevant;
    }

    public static boolean isPathRelevant(int type) {
        return 0 <= type && type < PRIVILEGE_COUNT && PrivilegeType.values()[type].isPathRelevant;
    }

    static {
        PRIVILEGE_COUNT = PrivilegeType.values().length;
    }
}

