/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.recover;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.wal.exception.WALRecoverException;
import org.apache.iotdb.db.wal.recover.WALNodeRecoverTask;
import org.apache.iotdb.db.wal.recover.file.UnsealedTsFileRecoverPerformer;
import org.apache.iotdb.db.wal.utils.listener.WALRecoverListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALRecoverManager {
    private static final Logger logger = LoggerFactory.getLogger(WALRecoverManager.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private volatile boolean hasStarted = false;
    private volatile CountDownLatch allDataRegionScannedLatch;
    private ExecutorService recoverThreadPool;
    private final Map<String, UnsealedTsFileRecoverPerformer> absolutePath2RecoverPerformer = new ConcurrentHashMap<String, UnsealedTsFileRecoverPerformer>();

    private WALRecoverManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws WALRecoverException {
        block25: {
            logger.info("Start recovering wal.");
            try {
                ArrayList walNodeDirs = new ArrayList();
                for (String walDir : config.getWalDirs()) {
                    File walDirFile = SystemFileFactory.INSTANCE.getFile(walDir);
                    File[] nodeDirs = walDirFile.listFiles(File::isDirectory);
                    if (nodeDirs == null) continue;
                    for (File nodeDir : nodeDirs) {
                        if (!nodeDir.isDirectory()) continue;
                        walNodeDirs.add(nodeDir);
                    }
                }
                try {
                    this.allDataRegionScannedLatch.await();
                    this.hasStarted = true;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new WALRecoverException("Fail to recover wal.", interruptedException);
                }
                logger.info("Data regions have submitted all unsealed TsFiles, start recovering TsFiles in each wal node.");
                if (!walNodeDirs.isEmpty()) {
                    this.recoverThreadPool = IoTDBThreadPoolFactory.newCachedThreadPool((String)ThreadName.WAL_RECOVER.getName());
                    CountDownLatch countDownLatch = new CountDownLatch(walNodeDirs.size());
                    Iterator iterator = walNodeDirs.iterator();
                    while (iterator.hasNext()) {
                        File walNodeDir = (File)iterator.next();
                        this.recoverThreadPool.submit(new WALNodeRecoverTask(walNodeDir, countDownLatch));
                    }
                    try {
                        countDownLatch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new WALRecoverException("Fail to recover wal.", e);
                    }
                }
                for (UnsealedTsFileRecoverPerformer recoverPerformer2 : this.absolutePath2RecoverPerformer.values()) {
                    try {
                        recoverPerformer2.startRecovery();
                        recoverPerformer2.endRecovery();
                        recoverPerformer2.getRecoverListener().succeed();
                    }
                    catch (IOException | DataRegionException e) {
                        logger.error("Fail to recover unsealed TsFile {}, skip it.", (Object)recoverPerformer2.getTsFileAbsolutePath(), e);
                        recoverPerformer2.getRecoverListener().fail((Exception)e);
                    }
                }
            }
            catch (Exception e) {
                for (UnsealedTsFileRecoverPerformer recoverPerformer : this.absolutePath2RecoverPerformer.values()) {
                    recoverPerformer.getRecoverListener().fail(e);
                }
                break block25;
            }
            finally {
                for (UnsealedTsFileRecoverPerformer unsealedTsFileRecoverPerformer : this.absolutePath2RecoverPerformer.values()) {
                    try {
                        if (unsealedTsFileRecoverPerformer.canWrite()) continue;
                        unsealedTsFileRecoverPerformer.close();
                    }
                    catch (Exception exception) {}
                }
                this.stop();
            }
            for (UnsealedTsFileRecoverPerformer unsealedTsFileRecoverPerformer : this.absolutePath2RecoverPerformer.values()) {
                try {
                    if (unsealedTsFileRecoverPerformer.canWrite()) continue;
                    unsealedTsFileRecoverPerformer.close();
                }
                catch (Exception recoverPerformer2) {}
            }
            this.stop();
        }
        logger.info("Successfully recover all wal nodes.");
    }

    public WALRecoverListener addRecoverPerformer(UnsealedTsFileRecoverPerformer recoverPerformer) {
        if (this.hasStarted) {
            logger.error("Cannot recover tsfile from wal because wal recovery has already started");
        } else {
            this.absolutePath2RecoverPerformer.put(recoverPerformer.getTsFileAbsolutePath(), recoverPerformer);
        }
        return recoverPerformer.getRecoverListener();
    }

    UnsealedTsFileRecoverPerformer removeRecoverPerformer(String absolutePath) {
        return this.absolutePath2RecoverPerformer.remove(absolutePath);
    }

    public CountDownLatch getAllDataRegionScannedLatch() {
        return this.allDataRegionScannedLatch;
    }

    public void setAllDataRegionScannedLatch(CountDownLatch allDataRegionScannedLatch) {
        this.allDataRegionScannedLatch = allDataRegionScannedLatch;
    }

    public void stop() {
        this.absolutePath2RecoverPerformer.clear();
        if (this.recoverThreadPool != null) {
            this.recoverThreadPool.shutdown();
            this.recoverThreadPool = null;
        }
    }

    public void clear() {
        this.stop();
        this.hasStarted = false;
    }

    public static WALRecoverManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static class InstanceHolder {
        private static final WALRecoverManager INSTANCE = new WALRecoverManager();

        private InstanceHolder() {
        }
    }
}

