/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.node;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.multileader.wal.ConsensusReqReader;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.flush.FlushStatus;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.wal.buffer.IWALBuffer;
import org.apache.iotdb.db.wal.buffer.SignalWALEntry;
import org.apache.iotdb.db.wal.buffer.WALBuffer;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.apache.iotdb.db.wal.buffer.WALEntryType;
import org.apache.iotdb.db.wal.checkpoint.CheckpointManager;
import org.apache.iotdb.db.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.wal.io.WALReader;
import org.apache.iotdb.db.wal.node.IWALNode;
import org.apache.iotdb.db.wal.utils.WALFileStatus;
import org.apache.iotdb.db.wal.utils.WALFileUtils;
import org.apache.iotdb.db.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.wal.utils.listener.WALFlushListener;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.utils.TsFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALNode
implements IWALNode {
    private static final Logger logger = LoggerFactory.getLogger(WALNode.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final String identifier;
    private final File logDirectory;
    private final IWALBuffer buffer;
    private final CheckpointManager checkpointManager;
    private final Map<Long, Integer> memTableSnapshotCount = new ConcurrentHashMap<Long, Integer>();
    private final AtomicLong totalCostOfFlushedMemTables = new AtomicLong();
    private final Map<Long, Long> walFileVersionId2MemTablesTotalCost = new ConcurrentHashMap<Long, Long>();
    private volatile long safelyDeletedSearchIndex = Long.MAX_VALUE;

    public WALNode(String identifier, String logDirectory) throws FileNotFoundException {
        this(identifier, logDirectory, 0L, 0L);
    }

    public WALNode(String identifier, String logDirectory, long startFileVersion, long startSearchIndex) throws FileNotFoundException {
        this.identifier = identifier;
        this.logDirectory = SystemFileFactory.INSTANCE.getFile(logDirectory);
        if (!this.logDirectory.exists() && this.logDirectory.mkdirs()) {
            logger.info("create folder {} for wal node-{}.", (Object)logDirectory, (Object)identifier);
        }
        this.buffer = new WALBuffer(identifier, logDirectory, startFileVersion, startSearchIndex);
        this.checkpointManager = new CheckpointManager(identifier, logDirectory);
    }

    @Override
    public WALFlushListener log(long memTableId, InsertRowPlan insertRowPlan) {
        WALEntry walEntry = new WALEntry(memTableId, insertRowPlan);
        return this.log(walEntry);
    }

    @Override
    public WALFlushListener log(long memTableId, InsertRowNode insertRowNode) {
        if (insertRowNode.getSearchIndex() != -1L && insertRowNode.getSafelyDeletedSearchIndex() != Long.MAX_VALUE) {
            this.safelyDeletedSearchIndex = insertRowNode.getSafelyDeletedSearchIndex();
        }
        WALEntry walEntry = new WALEntry(memTableId, insertRowNode);
        return this.log(walEntry);
    }

    @Override
    public WALFlushListener log(long memTableId, InsertTabletPlan insertTabletPlan, int start, int end) {
        WALEntry walEntry = new WALEntry(memTableId, insertTabletPlan, start, end);
        return this.log(walEntry);
    }

    @Override
    public WALFlushListener log(long memTableId, InsertTabletNode insertTabletNode, int start, int end) {
        if (insertTabletNode.getSearchIndex() != -1L && insertTabletNode.getSafelyDeletedSearchIndex() != Long.MAX_VALUE) {
            this.safelyDeletedSearchIndex = insertTabletNode.getSafelyDeletedSearchIndex();
        }
        WALEntry walEntry = new WALEntry(memTableId, insertTabletNode, start, end);
        return this.log(walEntry);
    }

    @Override
    public WALFlushListener log(long memTableId, DeletePlan deletePlan) {
        WALEntry walEntry = new WALEntry(memTableId, deletePlan);
        return this.log(walEntry);
    }

    private WALFlushListener log(WALEntry walEntry) {
        this.buffer.write(walEntry);
        return walEntry.getWalFlushListener();
    }

    @Override
    public void onMemTableFlushStarted(IMemTable memTable) {
    }

    @Override
    public void onMemTableFlushed(IMemTable memTable) {
        if (memTable.isSignalMemTable()) {
            return;
        }
        this.checkpointManager.makeFlushMemTableCP(memTable.getMemTableId());
        this.memTableSnapshotCount.remove(memTable.getMemTableId());
        long cost = config.isEnableMemControl() ? memTable.getTVListsRamCost() : 1L;
        long currentWALFileVersion = this.buffer.getCurrentWALFileVersion();
        this.walFileVersionId2MemTablesTotalCost.compute(currentWALFileVersion, (k, v) -> v == null ? cost : v + cost);
        this.totalCostOfFlushedMemTables.addAndGet(cost);
    }

    @Override
    public void onMemTableCreated(IMemTable memTable, String targetTsFile) {
        if (memTable.isSignalMemTable()) {
            return;
        }
        long firstFileVersionId = this.buffer.getCurrentWALFileVersion();
        MemTableInfo memTableInfo = new MemTableInfo(memTable, targetTsFile, firstFileVersionId);
        this.checkpointManager.makeCreateMemTableCP(memTableInfo);
    }

    public void deleteOutdatedFiles() {
        try {
            new DeleteOutdatedFileTask().run();
        }
        catch (Exception e) {
            logger.error("Fail to delete wal node-{}'s outdated files.", (Object)this.identifier, (Object)e);
        }
    }

    public void setSafelyDeletedSearchIndex(long safelyDeletedSearchIndex) {
        this.safelyDeletedSearchIndex = safelyDeletedSearchIndex;
    }

    private static InsertNode mergeInsertNodes(List<InsertNode> insertNodes) {
        InsertNode result;
        int size = insertNodes.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            InsertNode insertNode = insertNodes.get(0);
            insertNode.setPlanNodeId(new PlanNodeId(""));
            return insertNode;
        }
        if (insertNodes.get(0) instanceof InsertTabletNode) {
            ArrayList<Integer> index = new ArrayList<Integer>(size);
            ArrayList<InsertTabletNode> insertTabletNodes = new ArrayList<InsertTabletNode>(size);
            int i = 0;
            for (InsertNode insertNode : insertNodes) {
                insertTabletNodes.add((InsertTabletNode)insertNode);
                index.add(i);
                ++i;
            }
            result = new InsertMultiTabletsNode(new PlanNodeId(""), index, insertTabletNodes);
        } else {
            boolean sameDevice = true;
            PartialPath device = insertNodes.get(0).getDevicePath();
            ArrayList<Integer> index = new ArrayList<Integer>(size);
            ArrayList<InsertRowNode> insertRowNodes = new ArrayList<InsertRowNode>(size);
            int i = 0;
            for (InsertNode insertNode : insertNodes) {
                if (sameDevice && !insertNode.getDevicePath().equals((Object)device)) {
                    sameDevice = false;
                }
                insertRowNodes.add((InsertRowNode)insertNode);
                index.add(i);
                ++i;
            }
            result = sameDevice ? new InsertRowsOfOneDeviceNode(new PlanNodeId(""), index, insertRowNodes) : new InsertRowsNode(new PlanNodeId(""), index, insertRowNodes);
        }
        ((InsertNode)result).setSearchIndex(insertNodes.get(0).getSearchIndex());
        result.setDevicePath(insertNodes.get(0).getDevicePath());
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IConsensusRequest getReq(long index) {
        File[] currentFiles = WALFileUtils.listAllWALFiles(this.logDirectory);
        WALFileUtils.ascSortByVersionId(currentFiles);
        int fileIndex = WALFileUtils.binarySearchFileBySearchIndex(currentFiles, index);
        if (fileIndex < 0) {
            return null;
        }
        ArrayList<InsertNode> tmpNodes = new ArrayList<InsertNode>();
        int i = fileIndex;
        while (i < currentFiles.length) {
            if (index < WALFileUtils.parseStartSearchIndex(currentFiles[i].getName())) {
                if (tmpNodes.isEmpty()) return null;
                return WALNode.mergeInsertNodes(tmpNodes);
            }
            if (WALFileUtils.parseStatusCode(currentFiles[i].getName()) == WALFileStatus.CONTAINS_NONE_SEARCH_INDEX) {
                if (!tmpNodes.isEmpty()) {
                    return WALNode.mergeInsertNodes(tmpNodes);
                }
            } else {
                try (WALReader walReader = new WALReader(currentFiles[i]);){
                    while (walReader.hasNext()) {
                        WALEntry walEntry = walReader.next();
                        if (walEntry.getType() == WALEntryType.INSERT_TABLET_NODE || walEntry.getType() == WALEntryType.INSERT_ROW_NODE) {
                            InsertNode insertNode = (InsertNode)((Object)walEntry.getValue());
                            if (insertNode.getSearchIndex() == index) {
                                tmpNodes.add(insertNode);
                                continue;
                            }
                            if (tmpNodes.isEmpty()) continue;
                            InsertNode insertNode2 = WALNode.mergeInsertNodes(tmpNodes);
                            return insertNode2;
                        }
                        if (tmpNodes.isEmpty()) continue;
                        InsertNode insertNode = WALNode.mergeInsertNodes(tmpNodes);
                        return insertNode;
                    }
                }
                catch (FileNotFoundException e) {
                    logger.debug("WAL file {} has been deleted, try to call getReq({}) again.", (Object)currentFiles[i], (Object)index);
                    return this.getReq(index);
                }
                catch (Exception e) {
                    logger.error("Fail to read wal from wal file {}", (Object)currentFiles[i], (Object)e);
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<IConsensusRequest> getReqs(long startIndex, int num) {
        ArrayList<IConsensusRequest> result = new ArrayList<IConsensusRequest>(num);
        File[] currentFiles = WALFileUtils.listAllWALFiles(this.logDirectory);
        WALFileUtils.ascSortByVersionId(currentFiles);
        int fileIndex = WALFileUtils.binarySearchFileBySearchIndex(currentFiles, startIndex);
        if (fileIndex < 0) {
            return result;
        }
        long endIndex = startIndex + (long)num - 1L;
        long targetIndex = startIndex;
        ArrayList<InsertNode> tmpNodes = new ArrayList<InsertNode>();
        int i = fileIndex;
        while (i < currentFiles.length) {
            block32: {
                block33: {
                    if (endIndex < WALFileUtils.parseStartSearchIndex(currentFiles[i].getName())) {
                        if (tmpNodes.isEmpty()) return result;
                        result.add(WALNode.mergeInsertNodes(tmpNodes));
                    }
                    if (WALFileUtils.parseStatusCode(currentFiles[i].getName()) != WALFileStatus.CONTAINS_NONE_SEARCH_INDEX) break block33;
                    if (tmpNodes.isEmpty()) break block32;
                    result.add(WALNode.mergeInsertNodes(tmpNodes));
                }
                try (WALReader walReader = new WALReader(currentFiles[i]);){
                    while (walReader.hasNext()) {
                        WALEntry walEntry = walReader.next();
                        if (walEntry.getType() == WALEntryType.INSERT_TABLET_NODE || walEntry.getType() == WALEntryType.INSERT_ROW_NODE) {
                            InsertNode insertNode = (InsertNode)((Object)walEntry.getValue());
                            if (insertNode.getSearchIndex() == targetIndex) {
                                tmpNodes.add(insertNode);
                                continue;
                            }
                            if (tmpNodes.isEmpty()) continue;
                            result.add(WALNode.mergeInsertNodes(tmpNodes));
                            if (result.size() == num) {
                                ArrayList<IConsensusRequest> arrayList = result;
                                return arrayList;
                            }
                            tmpNodes = new ArrayList();
                            if (insertNode.getSearchIndex() != ++targetIndex) continue;
                            tmpNodes.add(insertNode);
                            continue;
                        }
                        if (tmpNodes.isEmpty()) continue;
                        result.add(WALNode.mergeInsertNodes(tmpNodes));
                        if (result.size() == num) {
                            ArrayList<IConsensusRequest> arrayList = result;
                            return arrayList;
                        }
                        ++targetIndex;
                        tmpNodes = new ArrayList();
                    }
                }
                catch (FileNotFoundException e) {
                    logger.debug("WAL file {} has been deleted, try to call getReqs({}, {}) again.", new Object[]{currentFiles[i], startIndex, num});
                    return this.getReqs(startIndex, num);
                }
                catch (Exception e) {
                    logger.error("Fail to read wal from wal file {}", (Object)currentFiles[i], (Object)e);
                }
            }
            ++i;
        }
        return result;
    }

    public ConsensusReqReader.ReqIterator getReqIterator(long startIndex) {
        return new PlanNodeIterator(startIndex);
    }

    @Override
    public void close() {
        this.buffer.close();
        this.checkpointManager.close();
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    boolean isAllWALEntriesConsumed() {
        return this.buffer.isAllWALEntriesConsumed();
    }

    long getCurrentLogVersion() {
        return this.buffer.getCurrentWALFileVersion();
    }

    public void rollWALFile() {
        SignalWALEntry rollWALFileSignal = new SignalWALEntry(SignalWALEntry.SignalType.ROLL_WAL_LOG_WRITER_SIGNAL, true);
        WALFlushListener walFlushListener = this.log(rollWALFileSignal);
        if (walFlushListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
            logger.error("Fail to trigger rolling wal node-{}'s wal file log writer.", (Object)this.identifier, (Object)walFlushListener.getCause());
        }
    }

    private class PlanNodeIterator
    implements ConsensusReqReader.ReqIterator {
        private long nextSearchIndex;
        private File[] filesToSearch = null;
        private int currentFileIndex = -1;
        private boolean needUpdatingFilesToSearch = true;
        private long searchedFilesVersionId = 0L;
        private final List<InsertNode> insertNodes = new LinkedList<InsertNode>();
        private Iterator<InsertNode> itr = null;

        public PlanNodeIterator(long startIndex) {
            this.nextSearchIndex = startIndex;
        }

        public boolean hasNext() {
            if (this.itr != null && this.itr.hasNext()) {
                return true;
            }
            this.insertNodes.clear();
            this.itr = null;
            if (this.needUpdatingFilesToSearch || this.filesToSearch == null) {
                this.updateFilesToSearch();
                if (this.needUpdatingFilesToSearch) {
                    return false;
                }
            }
            while (WALFileUtils.parseStatusCode(this.filesToSearch[this.currentFileIndex].getName()) == WALFileStatus.CONTAINS_NONE_SEARCH_INDEX) {
                ++this.currentFileIndex;
                if (this.currentFileIndex < this.filesToSearch.length) continue;
                this.needUpdatingFilesToSearch = true;
                return false;
            }
            List<InsertNode> tmpNodes = new ArrayList<InsertNode>();
            long targetIndex = this.nextSearchIndex;
            try (WALReader walReader = new WALReader(this.filesToSearch[this.currentFileIndex]);){
                while (walReader.hasNext()) {
                    WALEntry walEntry = walReader.next();
                    if (walEntry.getType() == WALEntryType.INSERT_TABLET_NODE || walEntry.getType() == WALEntryType.INSERT_ROW_NODE) {
                        InsertNode insertNode = (InsertNode)((Object)walEntry.getValue());
                        if (insertNode.getSearchIndex() == targetIndex) {
                            tmpNodes.add(insertNode);
                            continue;
                        }
                        if (tmpNodes.isEmpty()) continue;
                        this.insertNodes.add(WALNode.mergeInsertNodes(tmpNodes));
                        tmpNodes = new ArrayList();
                        if (insertNode.getSearchIndex() != ++targetIndex) continue;
                        tmpNodes.add((InsertNode)((Object)insertNode));
                        continue;
                    }
                    if (tmpNodes.isEmpty()) continue;
                    this.insertNodes.add(WALNode.mergeInsertNodes(tmpNodes));
                    ++targetIndex;
                    tmpNodes = new ArrayList();
                }
            }
            catch (FileNotFoundException e) {
                logger.debug("WAL file {} has been deleted, try to find next {} again.", (Object)WALNode.this.identifier, (Object)this.nextSearchIndex);
                this.reset();
                this.hasNext();
            }
            catch (Exception e) {
                logger.error("Fail to read wal from wal file {}", (Object)this.filesToSearch[this.currentFileIndex], (Object)e);
            }
            if (tmpNodes.isEmpty()) {
                ++this.currentFileIndex;
            } else {
                int fileIndex = this.currentFileIndex + 1;
                while (!tmpNodes.isEmpty() && fileIndex < this.filesToSearch.length) {
                    if (WALFileUtils.parseStatusCode(this.filesToSearch[fileIndex].getName()) == WALFileStatus.CONTAINS_NONE_SEARCH_INDEX) {
                        this.insertNodes.add(WALNode.mergeInsertNodes(tmpNodes));
                        tmpNodes = Collections.emptyList();
                        break;
                    }
                    try (WALReader walReader = new WALReader(this.filesToSearch[fileIndex]);){
                        while (walReader.hasNext()) {
                            WALEntry walEntry = walReader.next();
                            if (walEntry.getType() == WALEntryType.INSERT_TABLET_NODE || walEntry.getType() == WALEntryType.INSERT_ROW_NODE) {
                                InsertNode insertNode = (InsertNode)((Object)walEntry.getValue());
                                if (insertNode.getSearchIndex() == targetIndex) {
                                    tmpNodes.add((InsertNode)((Object)insertNode));
                                    continue;
                                }
                                if (tmpNodes.isEmpty()) continue;
                                this.insertNodes.add(WALNode.mergeInsertNodes(tmpNodes));
                                tmpNodes = Collections.emptyList();
                            } else {
                                if (tmpNodes.isEmpty()) continue;
                                this.insertNodes.add(WALNode.mergeInsertNodes(tmpNodes));
                                tmpNodes = Collections.emptyList();
                            }
                            break;
                        }
                    }
                    catch (FileNotFoundException e) {
                        logger.debug("WAL file {} has been deleted, try to find next {} again.", (Object)WALNode.this.identifier, (Object)this.nextSearchIndex);
                        this.reset();
                        this.hasNext();
                    }
                    catch (Exception e) {
                        logger.error("Fail to read wal from wal file {}", (Object)this.filesToSearch[this.currentFileIndex], (Object)e);
                    }
                    if (tmpNodes.isEmpty()) continue;
                    ++fileIndex;
                }
                if (tmpNodes.isEmpty()) {
                    this.currentFileIndex = fileIndex;
                } else {
                    this.needUpdatingFilesToSearch = true;
                }
            }
            if (this.currentFileIndex >= this.filesToSearch.length) {
                this.needUpdatingFilesToSearch = true;
            } else {
                this.searchedFilesVersionId = WALFileUtils.parseVersionId(this.filesToSearch[this.currentFileIndex].getName());
            }
            if (this.insertNodes.size() != 0) {
                this.itr = this.insertNodes.iterator();
                return true;
            }
            return false;
        }

        public IConsensusRequest next() {
            if (this.itr == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            InsertNode insertNode = this.itr.next();
            if (insertNode.getSearchIndex() == this.nextSearchIndex) {
                ++this.nextSearchIndex;
            } else if (insertNode.getSearchIndex() > this.nextSearchIndex) {
                logger.warn("Search index of wal node-{} are not continuously, skip from {} to {}.", new Object[]{WALNode.this.identifier, this.nextSearchIndex, insertNode.getSearchIndex()});
                this.skipTo(insertNode.getSearchIndex() + 1L);
            } else {
                logger.error("Search index of wal node-{} are out of order, {} is before {}.", new Object[]{WALNode.this.identifier, this.nextSearchIndex, insertNode.getSearchIndex()});
                throw new RuntimeException(String.format("Search index of wal node-%s are out of order", WALNode.this.identifier));
            }
            return insertNode;
        }

        public void waitForNextReady() throws InterruptedException {
            while (!this.hasNext()) {
                WALNode.this.buffer.waitForFlush();
            }
        }

        public void waitForNextReady(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
            if (!this.hasNext()) {
                boolean timeout;
                boolean bl = timeout = !WALNode.this.buffer.waitForFlush(time, unit);
                if (timeout || !this.hasNext()) {
                    throw new TimeoutException();
                }
            }
        }

        public void skipTo(long targetIndex) {
            if (targetIndex < this.nextSearchIndex) {
                logger.warn("Skip from {} to {}, it's a dangerous operation because insert plan {} may have been lost.", new Object[]{this.nextSearchIndex, targetIndex, targetIndex});
            }
            this.reset();
            this.nextSearchIndex = targetIndex;
        }

        private void reset() {
            this.searchedFilesVersionId = -1L;
            this.insertNodes.clear();
            this.itr = null;
            this.filesToSearch = null;
            this.currentFileIndex = -1;
            this.needUpdatingFilesToSearch = true;
        }

        private void updateFilesToSearch() {
            File[] filesToSearch = WALNode.this.logDirectory.listFiles(this::filterFilesToSearch);
            WALFileUtils.ascSortByVersionId(filesToSearch);
            int fileIndex = WALFileUtils.binarySearchFileBySearchIndex(filesToSearch, this.nextSearchIndex);
            if (filesToSearch != null && fileIndex >= 0) {
                this.filesToSearch = filesToSearch;
                this.currentFileIndex = fileIndex;
                this.searchedFilesVersionId = WALFileUtils.parseVersionId(this.filesToSearch[this.currentFileIndex].getName());
                this.needUpdatingFilesToSearch = false;
            } else {
                this.filesToSearch = null;
                this.currentFileIndex = -1;
                this.needUpdatingFilesToSearch = true;
            }
        }

        private boolean filterFilesToSearch(File dir, String name) {
            Pattern pattern = WALFileUtils.WAL_FILE_NAME_PATTERN;
            Matcher matcher = pattern.matcher(name);
            boolean toSearch = false;
            if (matcher.find()) {
                long versionId = Long.parseLong(matcher.group("versionId"));
                toSearch = versionId >= this.searchedFilesVersionId;
            }
            return toSearch;
        }
    }

    private class DeleteOutdatedFileTask
    implements Runnable {
        private static final int MAX_RECURSION_TIME = 5;
        private long firstValidVersionId;
        private int recursionTime = 0;

        private DeleteOutdatedFileTask() {
        }

        @Override
        public void run() {
            long costOfFlushedMemTables;
            this.firstValidVersionId = WALNode.this.checkpointManager.getFirstValidWALVersionId();
            if (this.firstValidVersionId == Long.MIN_VALUE) {
                if (WALNode.this.buffer.getCurrentWALFileSize() > 0L) {
                    WALNode.this.rollWALFile();
                }
                this.firstValidVersionId = WALNode.this.checkpointManager.getFirstValidWALVersionId();
                if (this.firstValidVersionId == Long.MIN_VALUE) {
                    this.firstValidVersionId = WALNode.this.buffer.getCurrentWALFileVersion();
                }
            }
            logger.debug("Start deleting outdated wal files for wal node-{}, the first valid version id is {}, and the safely deleted search index is {}.", new Object[]{WALNode.this.identifier, this.firstValidVersionId, WALNode.this.safelyDeletedSearchIndex});
            this.deleteOutdatedFiles();
            if (WALNode.this.safelyDeletedSearchIndex != Long.MAX_VALUE) {
                return;
            }
            long costOfActiveMemTables = WALNode.this.checkpointManager.getTotalCostOfActiveMemTables();
            long totalCost = costOfActiveMemTables + (costOfFlushedMemTables = WALNode.this.totalCostOfFlushedMemTables.get());
            if (totalCost == 0L) {
                return;
            }
            double effectiveInfoRatio = (double)costOfActiveMemTables / (double)totalCost;
            logger.debug("Effective information ratio is {}, active memTables cost is {}, flushed memTables cost is {}", new Object[]{effectiveInfoRatio, costOfActiveMemTables, costOfFlushedMemTables});
            if (effectiveInfoRatio < config.getWalMinEffectiveInfoRatio()) {
                logger.info("Effective information ratio {} (active memTables cost is {}, flushed memTables cost is {}) of wal node-{} is below wal min effective info ratio {}, some mamTables will be snapshot or flushed.", new Object[]{effectiveInfoRatio, costOfActiveMemTables, costOfFlushedMemTables, WALNode.this.identifier, config.getWalMinEffectiveInfoRatio()});
                if (this.snapshotOrFlushMemTable() && this.recursionTime < 5) {
                    this.run();
                    ++this.recursionTime;
                }
            }
        }

        private void deleteOutdatedFiles() {
            int endFileIndex;
            File[] filesToDelete = WALNode.this.logDirectory.listFiles(this::filterFilesToDelete);
            if (filesToDelete == null) {
                return;
            }
            WALFileUtils.ascSortByVersionId(filesToDelete);
            int n = endFileIndex = WALNode.this.safelyDeletedSearchIndex == Long.MAX_VALUE ? filesToDelete.length : WALFileUtils.binarySearchFileBySearchIndex(filesToDelete, WALNode.this.safelyDeletedSearchIndex + 1L);
            if (endFileIndex == -1) {
                ++endFileIndex;
            }
            while (endFileIndex < filesToDelete.length && WALFileUtils.parseStatusCode(filesToDelete[endFileIndex].getName()) != WALFileStatus.CONTAINS_SEARCH_INDEX) {
                ++endFileIndex;
            }
            int deletedFilesNum = 0;
            for (int i = 0; i < endFileIndex; ++i) {
                if (filesToDelete[i].delete()) {
                    ++deletedFilesNum;
                } else {
                    logger.info("Fail to delete outdated wal file {} of wal node-{}.", (Object)filesToDelete[i], (Object)WALNode.this.identifier);
                }
                long versionId = WALFileUtils.parseVersionId(filesToDelete[i].getName());
                Long memTableRamCostSum = (Long)WALNode.this.walFileVersionId2MemTablesTotalCost.remove(versionId);
                if (memTableRamCostSum == null) continue;
                WALNode.this.totalCostOfFlushedMemTables.addAndGet(-memTableRamCostSum.longValue());
            }
            logger.debug("Successfully delete {} outdated wal files for wal node-{}.", (Object)deletedFilesNum, (Object)WALNode.this.identifier);
        }

        private boolean filterFilesToDelete(File dir, String name) {
            Pattern pattern = WALFileUtils.WAL_FILE_NAME_PATTERN;
            Matcher matcher = pattern.matcher(name);
            boolean toDelete = false;
            if (matcher.find()) {
                long versionId = Long.parseLong(matcher.group("versionId"));
                toDelete = versionId < this.firstValidVersionId;
            }
            return toDelete;
        }

        private boolean snapshotOrFlushMemTable() {
            DataRegion dataRegion;
            MemTableInfo oldestMemTableInfo = WALNode.this.checkpointManager.getOldestMemTableInfo();
            if (oldestMemTableInfo == null) {
                return false;
            }
            IMemTable oldestMemTable = oldestMemTableInfo.getMemTable();
            File oldestTsFile = FSFactoryProducer.getFSFactory().getFile(oldestMemTableInfo.getTsFilePath());
            try {
                dataRegion = config.isMppMode() ? StorageEngineV2.getInstance().getDataRegion(new DataRegionId(TsFileUtils.getDataRegionId((File)oldestTsFile))) : StorageEngine.getInstance().getProcessorByDataRegionId(new PartialPath(TsFileUtils.getStorageGroup((File)oldestTsFile)), TsFileUtils.getDataRegionId((File)oldestTsFile));
            }
            catch (IllegalPathException | StorageEngineException e) {
                logger.error("Fail to get virtual storage group processor for {}", (Object)oldestTsFile, e);
                return false;
            }
            int snapshotCount = WALNode.this.memTableSnapshotCount.getOrDefault(oldestMemTable.getMemTableId(), 0);
            if (snapshotCount >= config.getMaxWalMemTableSnapshotNum() || oldestMemTable.getTVListsRamCost() > config.getWalMemTableSnapshotThreshold()) {
                this.flushMemTable(dataRegion, oldestTsFile, oldestMemTable);
            } else {
                this.snapshotMemTable(dataRegion, oldestTsFile, oldestMemTableInfo);
            }
            return true;
        }

        private void flushMemTable(DataRegion dataRegion, File tsFile, IMemTable memTable) {
            boolean submitted = true;
            if (memTable.getFlushStatus() == FlushStatus.WORKING) {
                submitted = dataRegion.submitAFlushTask(TsFileUtils.getTimePartition((File)tsFile), TsFileUtils.isSequence((File)tsFile), memTable);
                logger.info("WAL node-{} flushes memTable-{} to TsFile {}, memTable size is {}.", new Object[]{WALNode.this.identifier, memTable.getMemTableId(), tsFile, memTable.getTVListsRamCost()});
            }
            if (submitted || memTable.getFlushStatus() == FlushStatus.FLUSHING) {
                long sleepTime = 0L;
                while (memTable.getFlushStatus() != FlushStatus.FLUSHED) {
                    try {
                        Thread.sleep(1000L);
                        if ((sleepTime += 1000L) <= 10000L) continue;
                        logger.warn("Waiting too long for memTable flush to be done.");
                        break;
                    }
                    catch (InterruptedException e) {
                        logger.warn("Interrupted when waiting for memTable flush to be done.");
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void snapshotMemTable(DataRegion dataRegion, File tsFile, MemTableInfo memTableInfo) {
            IMemTable memTable = memTableInfo.getMemTable();
            if (memTable.getFlushStatus() != FlushStatus.WORKING) {
                return;
            }
            WALNode.this.memTableSnapshotCount.compute(memTable.getMemTableId(), (k, v) -> v == null ? 1 : v + 1);
            SignalWALEntry rollWALFileSignal = new SignalWALEntry(SignalWALEntry.SignalType.ROLL_WAL_LOG_WRITER_SIGNAL, true);
            WALFlushListener fileRolledListener = WALNode.this.log(rollWALFileSignal);
            if (fileRolledListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
                logger.error("Fail to roll wal log writer.", (Throwable)fileRolledListener.getCause());
                return;
            }
            memTableInfo.setFirstFileVersionId(WALNode.this.buffer.getCurrentWALFileVersion());
            dataRegion.writeLock("CheckpointManager$DeleteOutdatedFileTask.snapshotOrFlushOldestMemTable");
            try {
                WALEntry walEntry = new WALEntry(memTable.getMemTableId(), memTable, true);
                WALFlushListener flushListener = WALNode.this.log(walEntry);
                if (flushListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
                    logger.error("Fail to snapshot memTable of {}", (Object)tsFile, (Object)flushListener.getCause());
                }
                logger.info("WAL node-{} snapshots memTable-{} to wal files, memTable size is {}.", new Object[]{WALNode.this.identifier, memTable.getMemTableId(), memTable.getTVListsRamCost()});
            }
            finally {
                dataRegion.writeUnlock();
            }
        }
    }
}

