/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.conf.OperationType;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.QueryInBatchStatementException;
import org.apache.iotdb.db.exception.StorageGroupNotReadyException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.query.QueryTimeoutRuntimeException;
import org.apache.iotdb.db.exception.sql.SQLParserException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.exception.TsFileRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandlingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandlingUtils.class);
    private static final Logger DETAILED_FAILURE_QUERY_TRACE_LOGGER = LoggerFactory.getLogger((String)"DETAILED_FAILURE_QUERY_TRACE");
    private static final String INFO_PARSING_SQL_ERROR = "Error occurred while parsing SQL to physical plan: ";
    private static final String INFO_CHECK_METADATA_ERROR = "Check metadata error: ";
    private static final String INFO_QUERY_PROCESS_ERROR = "Error occurred in query process: ";
    private static final String INFO_NOT_ALLOWED_IN_BATCH_ERROR = "The query statement is not allowed in batch: ";

    public static TSStatus onNPEOrUnexpectedException(Exception e, String operation, TSStatusCode statusCode) {
        String message = String.format("[%s] Exception occurred: %s failed. ", statusCode, operation);
        if (e instanceof IOException || e instanceof NullPointerException) {
            LOGGER.error("Status code: " + statusCode + ", operation: " + operation + " failed", (Throwable)e);
        } else {
            LOGGER.warn("Status code: " + statusCode + ", operation: " + operation + " failed", (Throwable)e);
        }
        return RpcUtils.getStatus((TSStatusCode)statusCode, (String)(message + e.getMessage()));
    }

    public static TSStatus onNPEOrUnexpectedException(Exception e, OperationType operation, TSStatusCode statusCode) {
        return ErrorHandlingUtils.onNPEOrUnexpectedException(e, operation.getName(), statusCode);
    }

    public static Throwable getRootCause(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public static TSStatus onQueryException(Exception e, String operation) {
        TSStatus status = ErrorHandlingUtils.tryCatchQueryException(e);
        if (status != null) {
            if (status.getCode() != TSStatusCode.STORAGE_GROUP_NOT_READY.getStatusCode()) {
                LOGGER.error("Status code: " + status.getCode() + ", Query Statement: " + operation + " failed", (Throwable)e);
            }
            return status;
        }
        return ErrorHandlingUtils.onNPEOrUnexpectedException(e, operation, TSStatusCode.INTERNAL_SERVER_ERROR);
    }

    public static TSStatus onQueryException(Exception e, OperationType operation) {
        return ErrorHandlingUtils.onQueryException(e, operation.getName());
    }

    public static TSStatus tryCatchQueryException(Exception e) {
        Throwable t;
        Throwable rootCause = ErrorHandlingUtils.getRootCause(e);
        if (rootCause instanceof StorageGroupNotReadyException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.STORAGE_GROUP_NOT_READY, (String)rootCause.getMessage());
        }
        Throwable throwable = t = e instanceof ExecutionException ? e.getCause() : e;
        if (t instanceof QueryTimeoutRuntimeException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.TIME_OUT, (String)rootCause.getMessage());
        }
        if (t instanceof ParseCancellationException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)(INFO_PARSING_SQL_ERROR + rootCause.getMessage()));
        }
        if (t instanceof SQLParserException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)(INFO_CHECK_METADATA_ERROR + rootCause.getMessage()));
        }
        if (t instanceof QueryProcessException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_PROCESS_ERROR, (String)(INFO_QUERY_PROCESS_ERROR + rootCause.getMessage()));
        }
        if (t instanceof QueryInBatchStatementException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)(INFO_NOT_ALLOWED_IN_BATCH_ERROR + rootCause.getMessage()));
        }
        if (t instanceof IoTDBException) {
            return RpcUtils.getStatus((int)((IoTDBException)t).getErrorCode(), (String)rootCause.getMessage());
        }
        if (t instanceof TsFileRuntimeException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.TSFILE_PROCESSOR_ERROR, (String)rootCause.getMessage());
        }
        if (t instanceof SemanticException) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SEMANTIC_ERROR, (String)rootCause.getMessage());
        }
        if (t instanceof RuntimeException && rootCause instanceof IoTDBException) {
            return RpcUtils.getStatus((int)((IoTDBException)rootCause).getErrorCode(), (String)rootCause.getMessage());
        }
        return null;
    }

    public static TSStatus onNonQueryException(Exception e, String operation) {
        TSStatus status = ErrorHandlingUtils.tryCatchNonQueryException(e);
        return status != null ? status : ErrorHandlingUtils.onNPEOrUnexpectedException(e, operation, TSStatusCode.INTERNAL_SERVER_ERROR);
    }

    public static TSStatus onNonQueryException(Exception e, OperationType operation) {
        return ErrorHandlingUtils.onNonQueryException(e, operation.getName());
    }

    public static TSStatus tryCatchNonQueryException(Exception e) {
        String message = "Exception occurred while processing non-query. ";
        if (e instanceof BatchProcessException) {
            BatchProcessException batchException = (BatchProcessException)((Object)e);
            for (TSStatus status : batchException.getFailingStatus()) {
                if (status.getCode() != TSStatusCode.STORAGE_GROUP_NOT_READY.getStatusCode()) continue;
                return RpcUtils.getStatus(Arrays.asList(batchException.getFailingStatus()));
            }
            LOGGER.warn(message, (Throwable)e);
            return RpcUtils.getStatus(Arrays.asList(batchException.getFailingStatus()));
        }
        if (e instanceof IoTDBException) {
            Throwable rootCause = ErrorHandlingUtils.getRootCause(e);
            if (!(rootCause instanceof StorageGroupNotReadyException)) {
                LOGGER.warn(message, (Throwable)e);
            }
            return RpcUtils.getStatus((int)((IoTDBException)((Object)e)).getErrorCode(), (String)rootCause.getMessage());
        }
        return null;
    }

    public static TSStatus onIoTDBException(Exception e, String operation, int errorCode) {
        TSStatusCode statusCode = TSStatusCode.representOf((int)errorCode);
        String message = String.format("[%s] Exception occurred: %s failed. %s", statusCode, operation, e.getMessage());
        LOGGER.warn("Status code: " + statusCode + ", operation: " + operation + " failed", (Throwable)e);
        return RpcUtils.getStatus((int)errorCode, (String)message);
    }

    public static TSStatus onIoTDBException(Exception e, OperationType operation, int errorCode) {
        return ErrorHandlingUtils.onIoTDBException(e, operation.getName(), errorCode);
    }
}

