/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.dataregion;

import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.dataregion.HashVirtualPartitioner;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.service.IoTDB;

public class DeviceMappingViewer {
    public static void main(String[] args) throws MetadataException {
        if (args.length == 1) {
            IoTDBDescriptor.getInstance().getConfig().setSchemaDir(args[0]);
        }
        HashVirtualPartitioner partitioner = HashVirtualPartitioner.getInstance();
        IoTDB.configManager.init();
        LocalSchemaProcessor schemaProcessor = LocalSchemaProcessor.getInstance();
        Set<PartialPath> partialPathSet = schemaProcessor.getMatchedDevices(new PartialPath("root.**"), false);
        if (partialPathSet.isEmpty() && args.length == 1) {
            System.out.println("no mlog in given system schema dir: " + args[0] + " please have a check");
        } else {
            System.out.println();
            System.out.println("--------------------- mapping from device to virtual storage group ID ---------------------");
            System.out.println("Format is: device name -> virtual storage group ID");
            for (PartialPath partialPath : partialPathSet) {
                System.out.println(partialPath + " -> " + partitioner.deviceToDataRegionId(partialPath));
            }
        }
        IoTDB.configManager.clear();
    }
}

