/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.transport.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.SyncConnectionException;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.pipedata.TsFilePipeData;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.service.SenderService;
import org.apache.iotdb.db.sync.transport.client.ClientWrapper;
import org.apache.iotdb.db.sync.transport.client.ITransportClient;
import org.apache.iotdb.db.sync.transport.conf.TransportConfig;
import org.apache.iotdb.db.sync.transport.conf.TransportConstant;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.service.transport.thrift.MetaInfo;
import org.apache.iotdb.service.transport.thrift.RequestType;
import org.apache.iotdb.service.transport.thrift.ResponseType;
import org.apache.iotdb.service.transport.thrift.SyncRequest;
import org.apache.iotdb.service.transport.thrift.SyncResponse;
import org.apache.iotdb.service.transport.thrift.TransportService;
import org.apache.iotdb.service.transport.thrift.TransportStatus;
import org.apache.iotdb.service.transport.thrift.Type;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportClient
implements ITransportClient {
    private static final Logger logger = LoggerFactory.getLogger(TransportClient.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final int TRANSFER_BUFFER_SIZE_IN_BYTES = 0x100000;
    private final ClientWrapper serviceClient;
    private final ClientWrapper heartbeatClient;
    private final String ipAddress;
    private final int port;
    private final String localIP;
    private final Pipe pipe;
    private final Object waitLock;

    public TransportClient(Pipe pipe, String ipAddress, int port, String localIP) {
        RpcTransportFactory.setThriftMaxFrameSize((int)config.getThriftMaxFrameSize());
        this.pipe = pipe;
        this.ipAddress = ipAddress;
        this.port = port;
        this.waitLock = new Object();
        this.localIP = localIP;
        this.serviceClient = new ClientWrapper(pipe, ipAddress, port, localIP);
        this.heartbeatClient = new ClientWrapper(pipe, ipAddress, port, localIP);
    }

    public Object getWaitLock() {
        return this.waitLock;
    }

    public synchronized boolean handshake() throws SyncConnectionException {
        for (int handshakeCounter = 0; handshakeCounter < config.getMaxNumberOfSyncFileRetry(); ++handshakeCounter) {
            try {
                return this.serviceClient.handshakeWithVersion();
            }
            catch (SyncConnectionException e) {
                logger.warn(String.format("Handshake error, retry %d/%d.", handshakeCounter, config.getMaxNumberOfSyncFileRetry()));
                continue;
            }
        }
        if (!this.serviceClient.handshakeWithVersion()) {
            logger.info(String.format("Handshake failed %s times!", config.getMaxNumberOfSyncFileRetry()));
            return false;
        }
        return true;
    }

    public boolean senderTransport(PipeData pipeData) throws SyncConnectionException {
        if (pipeData instanceof TsFilePipeData) {
            try {
                for (File file : ((TsFilePipeData)pipeData).getTsFiles(true)) {
                    this.transportSingleFile(file);
                }
            }
            catch (IOException e) {
                logger.error(String.format("Get tsfiles error, because %s.", e), (Throwable)e);
                return false;
            }
            catch (NoSuchAlgorithmException e) {
                logger.error(String.format("Wrong message digest, because %s.", e), (Throwable)e);
                return false;
            }
        }
        int retryCount = 0;
        while (true) {
            if (++retryCount > config.getMaxNumberOfSyncFileRetry()) {
                logger.error(String.format("After %s tries, stop the transport of current pipeData!", retryCount));
                throw new SyncConnectionException(String.format("Can not connect to receiver when transferring pipedata %s.", pipeData));
            }
            try {
                this.transportPipeData(pipeData);
                logger.info(String.format("Finish pipeData %s transport.", pipeData));
            }
            catch (SyncConnectionException e) {
                try {
                    if (this.handshake()) continue;
                    logger.error(String.format("Handshake to receiver %s:%d error when transfer pipe data %s.", this.ipAddress, this.port, pipeData));
                    return false;
                }
                catch (SyncConnectionException syncConnectionException) {
                    logger.error(String.format("Reconnect to receiver %s:%d error when transfer pipe data %s.", this.ipAddress, this.port, pipeData));
                    throw new SyncConnectionException(String.format("Reconnect to receiver error when transferring pipedata %s.", pipeData));
                }
            }
            catch (NoSuchAlgorithmException e) {
                logger.error("Transport failed. ", (Throwable)e);
                return false;
            }
            break;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void transportSingleFile(File file) throws SyncConnectionException, NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        int retryCount = 0;
        while (true) {
            if (++retryCount > config.getMaxNumberOfSyncFileRetry()) {
                throw new SyncConnectionException(String.format("Connect to receiver error when transferring file %s.", file.getName()));
            }
            try {
                this.transportSingleFilePieceByPiece(file, messageDigest);
                if (!TransportConfig.isCheckFileDegistAgain) break;
                try {
                    if (this.checkFileDigest(file, messageDigest)) break;
                    continue;
                }
                catch (IOException e) {
                    logger.warn(String.format("Read from disk to make digest error, skip check file %s, because %s.", file.getName(), e));
                }
            }
            catch (SyncConnectionException e) {
                try {
                    if (!this.handshake()) throw new SyncConnectionException(String.format("Handshake with receiver error when transferring file %s.", file.getName()));
                    continue;
                }
                catch (SyncConnectionException syncConnectionException) {
                    throw new SyncConnectionException(String.format("Connect to receiver error when transferring file %s.", file.getName()));
                }
            }
            break;
        }
        logger.info("Receiver has received {} successfully.", (Object)file.getAbsoluteFile());
    }

    private void transportSingleFilePieceByPiece(File file, MessageDigest messageDigest) throws SyncConnectionException {
        long position = 0L;
        long limit = this.getFileSizeLimit(file);
        byte[] buffer = new byte[0x100000];
        block23: while (true) {
            if (position != 0L && buffer.length != TransportConstant.DATA_CHUNK_SIZE) {
                buffer = new byte[TransportConstant.DATA_CHUNK_SIZE];
            }
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                Throwable throwable = null;
                try {
                    int dataLength;
                    if (limit <= position) break;
                    randomAccessFile.seek(position);
                    do {
                        if ((dataLength = randomAccessFile.read(buffer, 0, Math.min(buffer.length, (int)(limit - position)))) == -1) continue block23;
                        messageDigest.reset();
                        messageDigest.update(buffer, 0, dataLength);
                        ByteBuffer buffToSend = ByteBuffer.wrap(buffer, 0, dataLength);
                        MetaInfo metaInfo = new MetaInfo(Type.FILE, file.getName(), position);
                        TransportStatus status = null;
                        int retryCount = 0;
                        while (true) {
                            if (++retryCount > config.getMaxNumberOfSyncFileRetry()) {
                                throw new SyncConnectionException(String.format("Can not sync file %s after %s tries.", file.getAbsoluteFile(), config.getMaxNumberOfSyncFileRetry()));
                            }
                            try {
                                status = this.serviceClient.getClient().transportData(metaInfo, buffToSend, ByteBuffer.wrap(messageDigest.digest()));
                            }
                            catch (TException e) {
                                logger.error("TException happened! ", (Throwable)e);
                                continue;
                            }
                            break;
                        }
                        if (status.code == -2) {
                            position = Long.parseLong(status.msg);
                            continue block23;
                        }
                        if (status.code == -3) {
                            logger.info("Receiver failed to receive data from {} because {}, retry.", (Object)file.getAbsoluteFile(), (Object)status.msg);
                            continue block23;
                        }
                        if (status.code == 1) continue;
                        logger.info("Receiver failed to receive data from {} because {}, abort.", (Object)file.getAbsoluteFile(), (Object)status.msg);
                        throw new SyncConnectionException(status.msg);
                    } while ((position += (long)dataLength) < limit);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (randomAccessFile == null) continue;
                    if (throwable != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    randomAccessFile.close();
                    continue;
                }
            }
            catch (IOException e) {
                logger.error("IOException happened! ", (Throwable)e);
                continue;
            }
            catch (SyncConnectionException e) {
                logger.error("Cannot sync data with receiver. ", (Throwable)((Object)e));
                throw e;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getFileSizeLimit(File file) {
        File offset = new File(file.getPath() + ".offset");
        if (!offset.exists()) return file.length();
        try (BufferedReader br = new BufferedReader(new FileReader(offset));){
            long l = Long.parseLong(br.readLine());
            return l;
        }
        catch (IOException e) {
            logger.error(String.format("Deserialize offset of file %s error, because %s.", file.getPath(), e));
        }
        return file.length();
    }

    private boolean checkFileDigest(File file, MessageDigest messageDigest) throws SyncConnectionException, IOException {
        TransportStatus status;
        messageDigest.reset();
        try (FileInputStream inputStream = new FileInputStream(file);){
            int length;
            byte[] block = new byte[TransportConstant.DATA_CHUNK_SIZE];
            while ((length = ((InputStream)inputStream).read(block)) > 0) {
                messageDigest.update(block, 0, length);
            }
        }
        MetaInfo metaInfo = new MetaInfo(Type.FILE, file.getName(), 0L);
        int retryCount = 0;
        while (true) {
            if (++retryCount > config.getMaxNumberOfSyncFileRetry()) {
                throw new SyncConnectionException(String.format("Can not sync file %s after %s tries.", file.getAbsoluteFile(), config.getMaxNumberOfSyncFileRetry()));
            }
            try {
                status = this.serviceClient.getClient().checkFileDigest(metaInfo, ByteBuffer.wrap(messageDigest.digest()));
            }
            catch (TException e) {
                logger.error("TException happens! ", (Throwable)e);
                continue;
            }
            break;
        }
        if (status.code != 1) {
            logger.error("Digest check of tsfile {} failed, retry", (Object)file.getAbsoluteFile());
            return false;
        }
        return true;
    }

    private void transportPipeData(PipeData pipeData) throws SyncConnectionException, NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        int retryCount = 0;
        while (true) {
            if (++retryCount > config.getMaxNumberOfSyncFileRetry()) {
                throw new SyncConnectionException(String.format("Can not sync pipe data after %s tries.", config.getMaxNumberOfSyncFileRetry()));
            }
            try {
                byte[] buffer = pipeData.serialize();
                messageDigest.reset();
                messageDigest.update(buffer);
                ByteBuffer buffToSend = ByteBuffer.wrap(buffer);
                MetaInfo metaInfo = new MetaInfo(Type.findByValue((int)pipeData.getType().ordinal()), "fileName", 0L);
                TransportStatus status = this.serviceClient.getClient().transportData(metaInfo, buffToSend, ByteBuffer.wrap(messageDigest.digest()));
                if (status.code == 1) break;
                logger.error("Digest check of pipeData failed, retry");
            }
            catch (IOException | TException e) {
                logger.error("Exception happened!", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            block9: while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (!this.handshake()) {
                        SenderService.getInstance().receiveMsg(new SyncResponse(ResponseType.ERROR, String.format("Can not handshake with %s:%d.", this.ipAddress, this.port)));
                    }
                    SenderService.getInstance().receiveMsg(this.heartbeat(new SyncRequest(RequestType.START, this.pipe.getName(), this.localIP, this.pipe.getCreateTime())));
                    while (true) {
                        if (Thread.currentThread().isInterrupted()) continue block9;
                        PipeData pipeData = this.pipe.take();
                        if (!this.senderTransport(pipeData)) {
                            logger.error(String.format("Can not transfer pipedata %s, skip it.", pipeData));
                            SenderService.getInstance().receiveMsg(new SyncResponse(ResponseType.WARN, String.format("Transfer piepdata %s error, skip it.", pipeData.getSerialNumber())));
                            continue;
                        }
                        this.pipe.commit();
                    }
                }
                catch (SyncConnectionException e) {
                    logger.error(String.format("Connect to receiver %s:%d error, because %s.", new Object[]{this.ipAddress, this.port, e}));
                    Object object = this.waitLock;
                    synchronized (object) {
                        SenderService.getInstance().setConnecting(true);
                        this.waitLock.wait();
                    }
                }
            }
            return;
        }
        catch (InterruptedException e) {
            logger.info("Interrupted by pipe, exit transport.");
            return;
        }
        finally {
            this.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SyncResponse heartbeat(SyncRequest syncRequest) throws SyncConnectionException {
        if (syncRequest.getType().equals((Object)RequestType.HEARTBEAT)) {
            return this.requestHeartbeat(syncRequest);
        }
        int retryCount = 0;
        while (true) {
            if (++retryCount > config.getMaxNumberOfSyncFileRetry()) {
                throw new SyncConnectionException(String.format("%s request connects to receiver %s:%d error.", syncRequest.type.name(), this.ipAddress, this.port));
            }
            try (TTransport heartbeatTransport = RpcTransportFactory.INSTANCE.getTransport((TTransport)new TSocket(TConfigurationConst.defaultTConfiguration, this.ipAddress, this.port, 100000, 1000));){
                Object protocol = config.isRpcThriftCompressionEnable() ? new TCompactProtocol(heartbeatTransport) : new TBinaryProtocol(heartbeatTransport);
                TransportService.Client heartbeatClient = new TransportService.Client((TProtocol)protocol);
                if (!heartbeatTransport.isOpen()) {
                    heartbeatTransport.open();
                }
                SyncResponse syncResponse = heartbeatClient.heartbeat(syncRequest);
                return syncResponse;
            }
            catch (TException e) {
                logger.info(String.format("Heartbeat connect to receiver %s:%d error, retry %d/%d.", this.ipAddress, this.port, retryCount, config.getMaxNumberOfSyncFileRetry()));
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncResponse requestHeartbeat(SyncRequest syncRequest) throws SyncConnectionException {
        if (this.heartbeatClient.getClient() == null) {
            ClientWrapper clientWrapper = this.heartbeatClient;
            synchronized (clientWrapper) {
                if (this.heartbeatClient.getClient() == null && !this.heartbeatClient.handshakeWithVersion()) {
                    throw new SyncConnectionException("Handshake with receiver error when heartbeat.");
                }
            }
        }
        int retryCount = 0;
        while (true) {
            if (++retryCount > config.getMaxNumberOfSyncFileRetry()) {
                throw new SyncConnectionException(String.format("%s request connects to receiver %s:%d error.", syncRequest.type.name(), this.ipAddress, this.port));
            }
            try {
                return this.heartbeatClient.getClient().heartbeat(syncRequest);
            }
            catch (TException e) {
                if (!this.heartbeatClient.handshakeWithVersion()) {
                    throw new SyncConnectionException("Handshake with receiver error when heartbeat.");
                }
                logger.info(String.format("Heartbeat connect to receiver %s:%d error, retry %d/%d.", this.ipAddress, this.port, retryCount, config.getMaxNumberOfSyncFileRetry()));
                continue;
            }
            break;
        }
    }

    public void close() {
        this.serviceClient.close();
        this.heartbeatClient.close();
    }
}

