/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.service;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.db.exception.SyncConnectionException;
import org.apache.iotdb.db.sync.conf.SyncConstant;
import org.apache.iotdb.db.sync.sender.pipe.IoTDBPipeSink;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.service.SenderService;
import org.apache.iotdb.db.sync.transport.client.ITransportClient;
import org.apache.iotdb.db.sync.transport.client.TransportClient;
import org.apache.iotdb.service.transport.thrift.RequestType;
import org.apache.iotdb.service.transport.thrift.SyncRequest;
import org.apache.iotdb.service.transport.thrift.SyncResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportHandler {
    private static final Logger logger = LoggerFactory.getLogger(TransportHandler.class);
    private static TransportHandler DEBUG_TRANSPORT_HANDLER = null;
    private String pipeName;
    private long createTime;
    private final String localIP;
    protected ITransportClient transportClient;
    private final Pipe pipe;
    protected ExecutorService transportExecutorService;
    private Future transportFuture;
    protected ScheduledExecutorService heartbeatExecutorService;
    private Future heartbeatFuture;

    public TransportHandler(Pipe pipe, IoTDBPipeSink pipeSink) {
        this.pipe = pipe;
        this.pipeName = pipe.getName();
        this.createTime = pipe.getCreateTime();
        this.transportExecutorService = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)(ThreadName.SYNC_SENDER_PIPE.getName() + "-" + this.pipeName));
        this.heartbeatExecutorService = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)(ThreadName.SYNC_SENDER_HEARTBEAT.getName() + "-" + this.pipeName));
        this.localIP = this.getLocalIP(pipeSink);
        this.transportClient = new TransportClient(pipe, pipeSink.getIp(), pipeSink.getPort(), this.localIP);
    }

    private String getLocalIP(IoTDBPipeSink pipeSink) {
        String localIP;
        block15: {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                if (inetAddress.isLoopbackAddress()) {
                    try (DatagramSocket socket = new DatagramSocket();){
                        socket.connect(InetAddress.getByName(pipeSink.getIp()), pipeSink.getPort());
                        localIP = socket.getLocalAddress().getHostAddress();
                        break block15;
                    }
                }
                localIP = inetAddress.getHostAddress();
            }
            catch (SocketException | UnknownHostException e) {
                logger.error(String.format("Get local host error when create transport handler.", new Object[0]), (Throwable)e);
                localIP = "UNKNOWN IP";
            }
        }
        return localIP;
    }

    public void start() {
        this.transportFuture = this.transportExecutorService.submit(this.transportClient);
        this.heartbeatFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.heartbeatExecutorService, this::sendHeartbeat, (long)0L, (long)SyncConstant.HEARTBEAT_DELAY_SECONDS, (TimeUnit)TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.transportFuture != null) {
            this.transportFuture.cancel(true);
        }
        if (this.heartbeatFuture != null) {
            this.heartbeatFuture.cancel(true);
        }
    }

    public boolean close() throws InterruptedException {
        this.transportExecutorService.shutdownNow();
        boolean isClosed = this.transportExecutorService.awaitTermination(SyncConstant.DEFAULT_WAITING_FOR_STOP_MILLISECONDS, TimeUnit.MILLISECONDS);
        this.heartbeatExecutorService.shutdownNow();
        return isClosed &= this.heartbeatExecutorService.awaitTermination(SyncConstant.DEFAULT_WAITING_FOR_STOP_MILLISECONDS, TimeUnit.MILLISECONDS);
    }

    public SyncResponse sendMsg(RequestType type) throws SyncConnectionException {
        return this.transportClient.heartbeat(new SyncRequest(type, this.pipeName, this.localIP, this.createTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHeartbeat() {
        try {
            SenderService.getInstance().receiveMsg(this.transportClient.heartbeat(new SyncRequest(RequestType.HEARTBEAT, this.pipeName, this.localIP, this.createTime)));
            Object object = ((TransportClient)this.transportClient).getWaitLock();
            synchronized (object) {
                this.pipe.setDisconnected(false);
                ((TransportClient)this.transportClient).getWaitLock().notifyAll();
            }
        }
        catch (SyncConnectionException e) {
            this.pipe.setDisconnected(true);
            logger.warn(String.format("Pipe %s sends heartbeat to receiver error, skip this time, because %s.", new Object[]{this.pipeName, e}));
        }
    }

    public static TransportHandler getNewTransportHandler(Pipe pipe, IoTDBPipeSink pipeSink) {
        if (DEBUG_TRANSPORT_HANDLER == null) {
            return new TransportHandler(pipe, pipeSink);
        }
        DEBUG_TRANSPORT_HANDLER.resetTransportClient(pipe);
        return DEBUG_TRANSPORT_HANDLER;
    }

    public static void setDebugTransportHandler(TransportHandler transportHandler) {
        DEBUG_TRANSPORT_HANDLER = transportHandler;
    }

    protected void resetTransportClient(Pipe pipe) {
        this.pipeName = pipe.getName();
        this.createTime = pipe.getCreateTime();
    }
}

