/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.storagegroup.dataregion.StorageGroupManager;
import org.apache.iotdb.db.sync.sender.pipe.TsFilePipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileSyncManager {
    private static final Logger logger = LoggerFactory.getLogger(TsFileSyncManager.class);
    private TsFilePipe syncPipe;

    private TsFileSyncManager() {
    }

    public static TsFileSyncManager getInstance() {
        return TsFileSyncManagerHolder.INSTANCE;
    }

    public void registerSyncTask(TsFilePipe syncPipe) {
        this.syncPipe = syncPipe;
    }

    public void deregisterSyncTask() {
        this.syncPipe = null;
    }

    public boolean isEnableSync() {
        return this.syncPipe != null;
    }

    public void clear() {
        this.syncPipe = null;
    }

    public void collectRealTimeDeletion(Deletion deletion) {
        this.syncPipe.collectRealTimeDeletion(deletion);
    }

    public void collectRealTimeTsFile(File tsFile) {
        this.syncPipe.collectRealTimeTsFile(tsFile);
    }

    public void collectRealTimeResource(File tsFile) {
        this.syncPipe.collectRealTimeResource(tsFile);
    }

    public List<File> registerAndCollectHistoryTsFile(TsFilePipe syncPipe, long dataStartTime) {
        this.registerSyncTask(syncPipe);
        ArrayList<File> historyTsFiles = new ArrayList<File>();
        Iterator<Map.Entry<PartialPath, StorageGroupManager>> sgIterator = StorageEngine.getInstance().getProcessorMap().entrySet().iterator();
        while (sgIterator.hasNext()) {
            historyTsFiles.addAll(sgIterator.next().getValue().collectHistoryTsFileForSync(dataStartTime));
        }
        return historyTsFiles;
    }

    public File createHardlink(File tsFile, long modsOffset) {
        return this.syncPipe.createHistoryTsFileHardlink(tsFile, modsOffset);
    }

    private static class TsFileSyncManagerHolder {
        private static final TsFileSyncManager INSTANCE = new TsFileSyncManager();

        private TsFileSyncManagerHolder() {
        }
    }
}

