/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.manager;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.MetadataConstant;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.sync.sender.pipe.TsFilePipe;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaSyncManager {
    private static final Logger logger = LoggerFactory.getLogger(SchemaSyncManager.class);
    private TsFilePipe syncPipe = null;

    public static SchemaSyncManager getInstance() {
        return SchemaSyncManagerHolder.INSTANCE;
    }

    public void registerSyncTask(TsFilePipe syncPipe) {
        this.syncPipe = syncPipe;
    }

    public void deregisterSyncTask() {
        this.syncPipe = null;
    }

    public boolean isEnableSync() {
        return this.syncPipe != null;
    }

    public void syncMetadataPlan(PhysicalPlan plan) {
        this.syncPipe.collectRealTimeMetaData(plan);
    }

    public void clear() {
        this.syncPipe = null;
    }

    public List<PhysicalPlan> collectHistoryMetadata() {
        ArrayList<PhysicalPlan> historyMetadata = new ArrayList<PhysicalPlan>();
        List<SetStorageGroupPlan> storageGroupPlanList = this.getStorageGroupAsPlan();
        for (SetStorageGroupPlan storageGroupPlan : storageGroupPlanList) {
            historyMetadata.add(storageGroupPlan);
        }
        for (ISchemaRegion schemaRegion : SchemaEngine.getInstance().getAllSchemaRegions()) {
            try {
                for (MeasurementPath measurementPath : schemaRegion.getMeasurementPaths(new PartialPath(MetadataConstant.ALL_RESULT_NODES), false)) {
                    if (measurementPath.isUnderAlignedEntity()) {
                        historyMetadata.add(new CreateAlignedTimeSeriesPlan(measurementPath.getDevicePath(), measurementPath.getMeasurement(), (MeasurementSchema)measurementPath.getMeasurementSchema()));
                        continue;
                    }
                    historyMetadata.add(new CreateTimeSeriesPlan(measurementPath, (MeasurementSchema)measurementPath.getMeasurementSchema()));
                }
            }
            catch (MetadataException e) {
                logger.warn(String.format("Collect history schema from schemaRegion: %s of sg %s error. Skip this schemaRegion.", schemaRegion.getSchemaRegionId(), schemaRegion.getStorageGroupFullPath()));
            }
        }
        return historyMetadata;
    }

    private List<SetStorageGroupPlan> getStorageGroupAsPlan() {
        List<PartialPath> allStorageGroups = IoTDB.configManager.getAllStorageGroupPaths();
        LinkedList<SetStorageGroupPlan> result = new LinkedList<SetStorageGroupPlan>();
        for (PartialPath sgPath : allStorageGroups) {
            result.add(new SetStorageGroupPlan(sgPath));
        }
        return result;
    }

    public DeleteTimeSeriesPlan splitDeleteTimeseriesPlanByDevice(PartialPath pathPattern) throws MetadataException {
        return new DeleteTimeSeriesPlan(this.splitPathPatternByDevice(pathPattern));
    }

    public List<PartialPath> splitPathPatternByDevice(PartialPath pathPattern) throws MetadataException {
        Set<PartialPath> devices = IoTDB.schemaProcessor.getBelongedDevices(pathPattern);
        LinkedList<PartialPath> resultPathPattern = new LinkedList<PartialPath>();
        for (PartialPath device : devices) {
            pathPattern.alterPrefixPath(device).stream().filter(i -> !i.equals((Object)device)).forEach(resultPathPattern::add);
        }
        return resultPathPattern;
    }

    private static class SchemaSyncManagerHolder {
        private static final SchemaSyncManager INSTANCE = new SchemaSyncManager();

        private SchemaSyncManagerHolder() {
        }
    }
}

