/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.load;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.exception.sync.PipeDataLoadException;
import org.apache.iotdb.db.exception.sync.PipeDataLoadUnbearableException;
import org.apache.iotdb.db.sync.receiver.load.ILoader;

public class DeletionLoader
implements ILoader {
    private Deletion deletion;

    public DeletionLoader(Deletion deletion) {
        this.deletion = deletion;
    }

    @Override
    public void load() throws PipeDataLoadException {
        if (IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new PipeDataLoadUnbearableException("storage engine readonly");
        }
        try {
            StorageEngine.getInstance().delete(this.deletion.getPath(), this.deletion.getStartTime(), this.deletion.getEndTime(), 0L, null);
        }
        catch (Exception e) {
            throw new PipeDataLoadUnbearableException(e.getMessage());
        }
    }
}

