/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.collector;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.db.exception.sync.PipeDataLoadBearableException;
import org.apache.iotdb.db.exception.sync.PipeDataLoadException;
import org.apache.iotdb.db.sync.conf.SyncPathUtil;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.pipedata.queue.BufferedPipeDataQueue;
import org.apache.iotdb.db.sync.pipedata.queue.PipeDataQueueFactory;
import org.apache.iotdb.db.sync.receiver.manager.PipeMessage;
import org.apache.iotdb.db.sync.receiver.manager.ReceiverManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Collector {
    private static final Logger logger = LoggerFactory.getLogger(Collector.class);
    private static final int WAIT_TIMEOUT = 2000;
    private ExecutorService executorService;
    private Map<String, Future> taskFutures = new ConcurrentHashMap<String, Future>();

    public void startCollect() {
        this.executorService = IoTDBThreadPoolFactory.newCachedThreadPool((String)ThreadName.SYNC_RECEIVER_COLLECTOR.getName());
    }

    public void stopCollect() {
        for (Future f : this.taskFutures.values()) {
            f.cancel(true);
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            int totalWaitTime = 2000;
            while (!this.executorService.isTerminated()) {
                try {
                    if (!this.executorService.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                        logger.info("{} thread pool doesn't exit after {}ms.", (Object)ThreadName.SYNC_RECEIVER_COLLECTOR.getName(), (Object)totalWaitTime);
                    }
                    totalWaitTime += 2000;
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while waiting {} thread pool to exit. ", (Object)ThreadName.SYNC_RECEIVER_COLLECTOR.getName());
                    Thread.currentThread().interrupt();
                }
            }
            this.executorService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPipe(String pipeName, String remoteIp, long createTime) {
        String dir = SyncPathUtil.getReceiverPipeDirName(pipeName, remoteIp, createTime);
        String string = dir.intern();
        synchronized (string) {
            if (!this.taskFutures.containsKey(dir)) {
                ScanTask task = new ScanTask(pipeName, remoteIp, createTime);
                this.taskFutures.put(dir, this.executorService.submit(task));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPipe(String pipeName, String remoteIp, long createTime) {
        String dir = SyncPathUtil.getReceiverPipeDirName(pipeName, remoteIp, createTime);
        logger.info("try stop task key={}", (Object)dir);
        String string = dir.intern();
        synchronized (string) {
            if (this.taskFutures.containsKey(dir)) {
                this.taskFutures.get(dir).cancel(true);
                this.taskFutures.remove(dir);
                logger.info("stop task success, key={}", (Object)dir);
            }
        }
    }

    private class ScanTask
    implements Runnable {
        private final String pipeName;
        private final String remoteIp;
        private final long createTime;

        private ScanTask(String pipeName, String remoteIp, long createTime) {
            this.pipeName = pipeName;
            this.remoteIp = remoteIp;
            this.createTime = createTime;
        }

        @Override
        public void run() {
            BufferedPipeDataQueue pipeDataQueue = PipeDataQueueFactory.getBufferedPipeDataQueue(SyncPathUtil.getReceiverPipeLogDir(this.pipeName, this.remoteIp, this.createTime));
            while (!Thread.currentThread().isInterrupted()) {
                PipeData pipeData = null;
                try {
                    pipeData = pipeDataQueue.take();
                    logger.info("Start load pipeData with serialize number {} and type {},value={}", new Object[]{pipeData.getSerialNumber(), pipeData.getType(), pipeData});
                    pipeData.createLoader().load();
                    pipeDataQueue.commit();
                    logger.info("Commit pipeData with serialize number {}", (Object)pipeData.getSerialNumber());
                }
                catch (InterruptedException e) {
                    logger.warn("Be interrupted when waiting for pipe data");
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (PipeDataLoadBearableException e) {
                    logger.warn(e.getMessage());
                    ReceiverManager.getInstance().writePipeMessage(this.pipeName, this.remoteIp, this.createTime, new PipeMessage(PipeMessage.MsgType.WARN, e.getMessage()));
                    pipeDataQueue.commit();
                }
                catch (PipeDataLoadException e) {
                    String msg = pipeData != null ? String.format("Cannot load pipeData with serialize number %d and type %s, because %s", new Object[]{pipeData.getSerialNumber(), pipeData.getType(), e.getMessage()}) : String.format("Cannot load pipeData because %s", e.getMessage());
                    logger.error(msg);
                    ReceiverManager.getInstance().writePipeMessage(this.pipeName, this.remoteIp, this.createTime, new PipeMessage(PipeMessage.MsgType.ERROR, msg));
                    break;
                }
            }
        }
    }
}

