/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.pipedata.queue;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.sync.pipedata.queue.BufferedPipeDataQueue;
import org.apache.iotdb.db.sync.pipedata.queue.PipeDataQueue;

public class PipeDataQueueFactory {
    private static final Map<String, BufferedPipeDataQueue> bufferedPipeDataQueueMap = new ConcurrentHashMap<String, BufferedPipeDataQueue>();

    public static BufferedPipeDataQueue getBufferedPipeDataQueue(String pipeLogDir) {
        return bufferedPipeDataQueueMap.computeIfAbsent(pipeLogDir, i -> new BufferedPipeDataQueue(pipeLogDir));
    }

    public static void removeBufferedPipeDataQueue(String pipeLogDir) {
        BufferedPipeDataQueue queue = bufferedPipeDataQueueMap.remove(pipeLogDir);
        if (queue != null) {
            queue.clear();
        }
    }

    public static void clear() {
        for (PipeDataQueue pipeDataQueue : bufferedPipeDataQueueMap.values()) {
            pipeDataQueue.clear();
        }
    }
}

