/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.pipedata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.receiver.load.DeletionLoader;
import org.apache.iotdb.db.sync.receiver.load.ILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionPipeData
extends PipeData {
    private static final Logger logger = LoggerFactory.getLogger(DeletionPipeData.class);
    private Deletion deletion;

    public DeletionPipeData(Deletion deletion, long serialNumber) {
        super(serialNumber);
        this.deletion = deletion;
    }

    @Override
    public PipeData.PipeDataType getType() {
        return PipeData.PipeDataType.DELETION;
    }

    @Override
    public long serialize(DataOutputStream stream) throws IOException {
        return super.serialize(stream) + this.deletion.serializeWithoutFileOffset(stream);
    }

    public static DeletionPipeData deserialize(DataInputStream stream) throws IOException, IllegalPathException {
        long serialNumber = stream.readLong();
        Deletion deletion = Deletion.deserializeWithoutFileOffset(stream);
        return new DeletionPipeData(deletion, serialNumber);
    }

    @Override
    public ILoader createLoader() {
        return new DeletionLoader(this.deletion);
    }

    public String toString() {
        return "DeletionData{serialNumber=" + this.serialNumber + ", deletion=" + this.deletion + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletionPipeData that = (DeletionPipeData)o;
        return Objects.equals(this.deletion, that.deletion) && Objects.equals(this.serialNumber, that.serialNumber);
    }

    public int hashCode() {
        return Objects.hash(this.deletion, this.serialNumber);
    }
}

