/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.externalpipe;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.sync.datasource.PipeOpManager;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePlugin;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginConfiguration;
import org.apache.iotdb.db.sync.externalpipe.ExternalPipeStatus;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.pipedata.TsFilePipeData;
import org.apache.iotdb.db.sync.sender.pipe.TsFilePipe;
import org.apache.iotdb.pipe.external.api.IExternalPipeSinkWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtPipePluginManager {
    private static final Logger logger = LoggerFactory.getLogger(ExtPipePluginManager.class);
    private TsFilePipe tsFilePipe;
    private PipeOpManager pipeOpManager;
    private Map<String, ExtPipePlugin> extPipePluginMap = new HashMap<String, ExtPipePlugin>();
    private ExecutorService monitorService = Executors.newFixedThreadPool(1);
    private long lastPipeDataSerialNumber = Long.MIN_VALUE;
    private Map<String, Map<String, AtomicInteger>> writerInvocationFailures;
    private final int timestampDivisor;

    public ExtPipePluginManager(TsFilePipe tsFilePipe) {
        String timePrecision;
        this.tsFilePipe = tsFilePipe;
        switch (timePrecision = IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ms": {
                this.timestampDivisor = 1;
                break;
            }
            case "us": {
                this.timestampDivisor = 1000;
                break;
            }
            case "ns": {
                this.timestampDivisor = 1000000;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized time precision: " + timePrecision);
            }
        }
        this.pipeOpManager = new PipeOpManager(tsFilePipe);
    }

    public ExtPipePluginManager(String Name2, IExternalPipeSinkWriterFactory factory, ExtPipePluginConfiguration conf, TsFilePipe tsFilePipe) {
        this(null);
    }

    public void setPipeOpManager(PipeOpManager pipeOpManager) {
        this.pipeOpManager = pipeOpManager;
    }

    public ExtPipePluginManager setTsFilePipe(TsFilePipe tsFilePipe) {
        this.tsFilePipe = tsFilePipe;
        return this;
    }

    public void startExtPipe(String pipeTypeName, Map<String, String> sinkParams) throws IOException {
        logger.debug("Enter startExtPipe(), pipeTypeName={}, sinkParams={}.", (Object)pipeTypeName, sinkParams);
        ExtPipePlugin extPipePlugin = this.extPipePluginMap.computeIfAbsent(pipeTypeName, k -> new ExtPipePlugin(pipeTypeName, sinkParams, this.pipeOpManager));
        if (extPipePlugin.isAlive()) {
            String eMsg = "startExtPipe(), External Pipe " + pipeTypeName + "has been alive, can not be started again.";
            logger.error(eMsg);
            throw new IOException(eMsg);
        }
        extPipePlugin.start();
        ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.monitorService;
        if (tpe.getActiveCount() <= 0 && tpe.getQueue().size() <= 0) {
            this.monitorService.submit(this::monitorPipeData);
        }
        logger.info("startExtPipe() finish. pipeTypeName={} ", (Object)pipeTypeName);
    }

    public void checkCommitIndex() {
        Set<String> sgSet = this.pipeOpManager.getSgSet();
        for (String sgName : sgSet) {
            long finalCommitIndex = Long.MAX_VALUE;
            for (ExtPipePlugin extPipePlugin : this.extPipePluginMap.values()) {
                long commitIndex = extPipePlugin.getDataCommitIndex(sgName);
                if (commitIndex < 0L || commitIndex >= finalCommitIndex) continue;
                finalCommitIndex = commitIndex;
            }
            if (finalCommitIndex >= Long.MAX_VALUE || finalCommitIndex < 0L) continue;
            this.pipeOpManager.commitData(sgName, finalCommitIndex);
        }
    }

    private void monitorPipeData() {
        Thread.currentThread().setName("ExternalPipe-monitorPipeData-" + Thread.currentThread().getId());
        logger.info("monitorPipeData start. Thread={}", (Object)Thread.currentThread().getName());
        if (this.tsFilePipe == null) {
            logger.info("monitorPipeData(), Error! tsFilePipe is null. Thread exit, {}.", (Object)Thread.currentThread().getName());
            return;
        }
        while (true) {
            List<PipeData> pipeDataList;
            if ((pipeDataList = this.tsFilePipe.pull(Long.MAX_VALUE)) != null && !pipeDataList.isEmpty() && pipeDataList.get(pipeDataList.size() - 1).getSerialNumber() > this.lastPipeDataSerialNumber) {
                for (PipeData pipeData : pipeDataList) {
                    long pipeDataSerialNumber = pipeData.getSerialNumber();
                    if (pipeDataSerialNumber <= this.lastPipeDataSerialNumber) continue;
                    this.lastPipeDataSerialNumber = pipeData.getSerialNumber();
                    if (!(pipeData instanceof TsFilePipeData)) continue;
                    TsFilePipeData tsFilePipeData = (TsFilePipeData)pipeData;
                    String sgName = tsFilePipeData.getStorageGroupName();
                    String tsFileFullName = tsFilePipeData.getTsFilePath();
                    try {
                        this.pipeOpManager.appendTsFile(sgName, tsFileFullName, pipeDataSerialNumber);
                    }
                    catch (IOException e) {
                        logger.error("monitorPipeData(), Can not append TsFile: {}" + tsFileFullName);
                    }
                }
            }
            this.checkCommitIndex();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                logger.info("monitorPipeData exits. Thread={}", (Object)Thread.currentThread().getName());
                return;
            }
        }
    }

    public void stopExtPipe(String extPipeTypeName) {
        logger.info("ExtPipePluginManager stop({}).", (Object)extPipeTypeName);
        ExtPipePlugin extPipePlugin = this.extPipePluginMap.get(extPipeTypeName);
        if (extPipePlugin == null) {
            logger.error("ExtPipePluginManager stop(), invalid extPipeTypeName={}", (Object)extPipeTypeName);
            return;
        }
        extPipePlugin.stop();
    }

    public void dropExtPipe(String pipeTypeName) {
        logger.info("ExtPipePluginManager drop {}.", (Object)pipeTypeName);
        ExtPipePlugin extPipePlugin = this.extPipePluginMap.get(pipeTypeName);
        if (extPipePlugin == null) {
            logger.error("ExtPipePluginManager dropExtPipe(), invalid pipeTypeName={}", (Object)pipeTypeName);
            return;
        }
        if (extPipePlugin.isAlive()) {
            extPipePlugin.stop();
        }
        this.extPipePluginMap.remove(pipeTypeName);
        if (this.extPipePluginMap.size() <= 0 && this.pipeOpManager != null) {
            this.pipeOpManager.close();
            this.pipeOpManager = null;
        }
    }

    public PipeOpManager getPipeOpManager() {
        return this.pipeOpManager;
    }

    public ExternalPipeStatus getExternalPipeStatus(String extPipeTypeName) {
        ExtPipePlugin extPipePlugin = this.extPipePluginMap.get(extPipeTypeName);
        if (extPipePlugin == null) {
            return null;
        }
        return extPipePlugin.getStatus();
    }
}

