/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.JMXService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.service.metrics.MetricsServiceMBean;
import org.apache.iotdb.db.service.metrics.predefined.FileMetrics;
import org.apache.iotdb.db.service.metrics.predefined.ProcessMetrics;
import org.apache.iotdb.db.service.metrics.predefined.SystemMetrics;
import org.apache.iotdb.metrics.MetricService;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.apache.iotdb.metrics.predefined.jvm.JvmMetrics;
import org.apache.iotdb.metrics.predefined.logback.LogbackMetrics;
import org.apache.iotdb.metrics.utils.PredefinedMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsService
extends MetricService
implements MetricsServiceMBean,
IService {
    private static final Logger logger = LoggerFactory.getLogger(MetricsService.class);
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());

    private MetricsService() {
    }

    public void start() throws StartupException {
        try {
            if (this.isEnable()) {
                logger.info("Start to start metric Service.");
                JMXService.registerMBean((Object)MetricsService.getInstance(), (String)this.mbeanName);
                this.startService();
                logger.info("Finish start metric Service");
            }
        }
        catch (Exception e) {
            logger.error("Failed to start {} because: ", (Object)this.getID().getName(), (Object)e);
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    public void stop() {
        if (this.isEnable()) {
            logger.info("Stop metric Service.");
            this.stopService();
            JMXService.deregisterMBean((String)this.mbeanName);
            logger.info("Finish stop metric Service");
        }
    }

    @Override
    public void restartService() throws StartupException {
        this.stopService();
        this.startService();
    }

    public void enablePredefinedMetric(PredefinedMetric metric) {
        Object metricSet;
        switch (metric) {
            case JVM: {
                metricSet = new JvmMetrics();
                break;
            }
            case LOGBACK: {
                metricSet = new LogbackMetrics();
                break;
            }
            case FILE: {
                metricSet = new FileMetrics();
                break;
            }
            case PROCESS: {
                metricSet = new ProcessMetrics();
                break;
            }
            case SYSTEM: {
                metricSet = new SystemMetrics();
                break;
            }
            default: {
                logger.error("Unknown predefined metrics: {}", (Object)metric);
                return;
            }
        }
        metricSet.bindTo(this.metricManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadProperties(ReloadLevel reloadLevel) {
        logger.info("Reload properties of metric service");
        MetricsService metricsService = this;
        synchronized (metricsService) {
            try {
                switch (reloadLevel) {
                    case START_METRIC: {
                        this.isEnableMetric = true;
                        this.start();
                        break;
                    }
                    case STOP_METRIC: {
                        this.stop();
                        this.isEnableMetric = false;
                        break;
                    }
                    case RESTART_METRIC: {
                        this.stop();
                        this.isEnableMetric = true;
                        this.start();
                        break;
                    }
                    case RESTART_REPORTER: {
                        this.compositeReporter.stopAll();
                        this.loadReporter();
                        this.compositeReporter.startAll();
                        logger.info("Finish restart metric reporters.");
                        break;
                    }
                    case NOTHING: {
                        logger.debug("There are nothing change in metric module.");
                        break;
                    }
                }
            }
            catch (StartupException startupException) {
                logger.error("Failed to start metric when reload properties");
            }
        }
    }

    public ServiceType getID() {
        return ServiceType.METRICS_SERVICE;
    }

    public static MetricsService getInstance() {
        return MetricsServiceHolder.INSTANCE;
    }

    private static class MetricsServiceHolder {
        private static final MetricsService INSTANCE = new MetricsService();

        private MetricsServiceHolder() {
        }
    }
}

