/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.settle.SettleLog;
import org.apache.iotdb.db.engine.settle.SettleTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.tools.settle.TsFileAndModSettleTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettleService
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(SettleService.class);
    private ExecutorService settleThreadPool;
    private boolean isRecoverFinish;
    private static AtomicInteger filesToBeSettledCount = new AtomicInteger();

    public static SettleService getINSTANCE() {
        return InstanceHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.settleThreadPool == null) {
            int settleThreadNum = IoTDBDescriptor.getInstance().getConfig().getSettleThreadNum();
            this.settleThreadPool = IoTDBThreadPoolFactory.newFixedThreadPool((int)settleThreadNum, (String)ThreadName.SETTLE_SERVICE.getName());
        }
        TsFileAndModSettleTool.findFilesToBeRecovered();
        HashMap<PartialPath, List> tmpSgResourcesMap = new HashMap<PartialPath, List>();
        try {
            for (String filePath : TsFileAndModSettleTool.getInstance().recoverSettleFileMap.keySet()) {
                PartialPath sgPath = this.getSGByFilePath(filePath);
                if (tmpSgResourcesMap.containsKey(sgPath)) {
                    List filePaths = (List)tmpSgResourcesMap.get(sgPath);
                    filePaths.add(filePath);
                    tmpSgResourcesMap.put(sgPath, filePaths);
                    continue;
                }
                ArrayList<String> tsFilePaths = new ArrayList<String>();
                tsFilePaths.add(filePath);
                tmpSgResourcesMap.put(sgPath, tsFilePaths);
            }
            while (!StorageEngine.getInstance().isAllSgReady()) {
            }
            ArrayList<TsFileResource> seqResourcesToBeSettled = new ArrayList<TsFileResource>();
            ArrayList<TsFileResource> unseqResourcesToBeSettled = new ArrayList<TsFileResource>();
            for (Map.Entry entry : tmpSgResourcesMap.entrySet()) {
                try {
                    StorageEngine.getInstance().getResourcesToBeSettled((PartialPath)entry.getKey(), seqResourcesToBeSettled, unseqResourcesToBeSettled, (List)entry.getValue());
                }
                catch (StorageEngineException e) {
                    e.printStackTrace();
                }
                finally {
                    StorageEngine.getInstance().setSettling((PartialPath)entry.getKey(), false);
                }
            }
            this.startSettling(seqResourcesToBeSettled, unseqResourcesToBeSettled);
            this.setRecoverFinish(true);
        }
        catch (WriteProcessException e) {
            e.printStackTrace();
        }
    }

    public void startSettling(List<TsFileResource> seqResourcesToBeSettled, List<TsFileResource> unseqResourcesToBeSettled) throws WriteProcessException {
        filesToBeSettledCount.addAndGet(seqResourcesToBeSettled.size() + unseqResourcesToBeSettled.size());
        if (!SettleLog.createSettleLog() || filesToBeSettledCount.get() == 0) {
            this.stop();
            return;
        }
        logger.info("Totally find " + (seqResourcesToBeSettled.size() + unseqResourcesToBeSettled.size()) + " tsFiles to be settled.");
        for (TsFileResource resource : seqResourcesToBeSettled) {
            resource.readLock();
            resource.setSeq(true);
            this.submitSettleTask(new SettleTask(resource));
        }
        for (TsFileResource resource : unseqResourcesToBeSettled) {
            resource.readLock();
            resource.setSeq(false);
            this.submitSettleTask(new SettleTask(resource));
        }
    }

    public void stop() {
        SettleLog.closeLogWriter();
        TsFileAndModSettleTool.clearRecoverSettleFileMap();
        filesToBeSettledCount.set(0);
        if (this.settleThreadPool != null) {
            this.settleThreadPool.shutdownNow();
            logger.info("Waiting for settle task pool to shut down");
            this.settleThreadPool = null;
            logger.info("Settle service stopped");
        }
    }

    public ServiceType getID() {
        return ServiceType.SETTLE_SERVICE;
    }

    public AtomicInteger getFilesToBeSettledCount() {
        return filesToBeSettledCount;
    }

    public PartialPath getSGByFilePath(String tsFilePath) throws WriteProcessException {
        PartialPath sgPath = null;
        try {
            sgPath = new PartialPath(new File(tsFilePath).getParentFile().getParentFile().getParentFile().getName());
        }
        catch (IllegalPathException e) {
            throw new WriteProcessException("Fail to get sg of this tsFile while parsing the file path.", e);
        }
        return sgPath;
    }

    private void submitSettleTask(SettleTask settleTask) throws WriteProcessException {
        settleTask.settleTsFile();
    }

    public boolean isRecoverFinish() {
        return this.isRecoverFinish;
    }

    public void setRecoverFinish(boolean recoverFinish) {
        this.isRecoverFinish = recoverFinish;
    }

    public static class InstanceHolder {
        private static final SettleService INSTANCE = new SettleService();

        private InstanceHolder() {
        }
    }
}

