/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.utils;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GroupByLevelController {
    public static String ALIAS_ERROR_MESSAGE1 = "alias '%s' can only be matched with one result column";
    public static String ALIAS_ERROR_MESSAGE2 = "Result column %s with more than one alias[%s, %s]";
    private final int seriesLimit;
    private int seriesOffset;
    Set<String> limitPaths;
    Set<String> offsetPaths;
    private final int[] levels;
    int prevSize = 0;
    private Map<String, String> groupedPathMap;
    private Map<String, String> columnToAliasMap;
    private Map<String, String> aliasToColumnMap;

    public GroupByLevelController(int seriesLimit, int[] levels) {
        this.seriesLimit = seriesLimit;
        this.levels = levels;
    }

    public GroupByLevelController(QueryOperator operator) {
        this.seriesLimit = operator.getSpecialClauseComponent().getSeriesLimit();
        this.seriesOffset = operator.getSpecialClauseComponent().getSeriesOffset();
        this.limitPaths = this.seriesLimit > 0 ? new HashSet() : null;
        this.offsetPaths = this.seriesOffset > 0 ? new HashSet() : null;
        this.groupedPathMap = new LinkedHashMap<String, String>();
        this.levels = operator.getLevels();
    }

    public String getGroupedPath(String rawPath) {
        return this.groupedPathMap.get(rawPath);
    }

    public String getAlias(String originName) {
        return this.columnToAliasMap != null && this.columnToAliasMap.get(originName) != null ? this.columnToAliasMap.get(originName) : null;
    }

    public void control(ResultColumn rawColumn, List<ResultColumn> resultColumns) throws LogicalOptimizeException {
        Set<Integer> countWildcardIterIndices = this.getCountStarIndices(rawColumn);
        Iterator<ResultColumn> iterator = resultColumns.iterator();
        for (int i = 0; i < this.prevSize; ++i) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            ResultColumn resultColumn = iterator.next();
            Expression rootExpression = resultColumn.getExpression();
            boolean hasAggregation = false;
            int idx = 0;
            Iterator<Expression> it = rootExpression.iterator();
            while (it.hasNext()) {
                Expression expression = it.next();
                if (!(expression instanceof FunctionExpression) || !expression.isBuiltInAggregationFunctionExpression()) continue;
                hasAggregation = true;
                List<PartialPath> paths = ((FunctionExpression)expression).getPaths();
                String functionName = ((FunctionExpression)expression).getFunctionName();
                boolean isCountStar = countWildcardIterIndices.contains(idx++);
                String groupedPath = this.generatePartialPathByLevel(isCountStar, paths.get(0).getNodes(), this.levels);
                String rawPath = String.format("%s(%s)", functionName, paths.get(0).getFullPath());
                String pathWithFunction = String.format("%s(%s)", functionName, groupedPath);
                if (this.seriesLimit == 0 && this.seriesOffset == 0) {
                    this.groupedPathMap.put(rawPath, pathWithFunction);
                    this.checkAliasAndUpdateAliasMap(rawColumn, pathWithFunction);
                    continue;
                }
                if (this.seriesOffset > 0 && this.offsetPaths != null) {
                    this.offsetPaths.add(pathWithFunction);
                    if (this.offsetPaths.size() > this.seriesOffset) continue;
                    iterator.remove();
                    if (this.offsetPaths.size() != this.seriesOffset) continue;
                    this.seriesOffset = 0;
                    continue;
                }
                if (this.offsetPaths == null || !this.offsetPaths.contains(pathWithFunction)) {
                    this.limitPaths.add(pathWithFunction);
                    if (this.seriesLimit > 0 && this.limitPaths.size() > this.seriesLimit) {
                        iterator.remove();
                        this.limitPaths.remove(pathWithFunction);
                        continue;
                    }
                    this.groupedPathMap.put(rawPath, pathWithFunction);
                    this.checkAliasAndUpdateAliasMap(rawColumn, pathWithFunction);
                    continue;
                }
                iterator.remove();
            }
            if (hasAggregation) continue;
            throw new LogicalOptimizeException(rootExpression + " can't be used in group by level.");
        }
        this.prevSize = resultColumns.size();
    }

    private Set<Integer> getCountStarIndices(ResultColumn rawColumn) {
        HashSet<Integer> countWildcardIterIndices = new HashSet<Integer>();
        int idx = 0;
        Iterator<Expression> it = rawColumn.getExpression().iterator();
        while (it.hasNext()) {
            Expression expression = it.next();
            if (expression instanceof FunctionExpression && expression.isBuiltInAggregationFunctionExpression() && ((FunctionExpression)expression).isCountStar()) {
                countWildcardIterIndices.add(idx);
            }
            ++idx;
        }
        return countWildcardIterIndices;
    }

    private void checkAliasAndUpdateAliasMap(ResultColumn rawColumn, String originName) throws LogicalOptimizeException {
        if (!rawColumn.hasAlias()) {
            return;
        }
        if (this.columnToAliasMap == null) {
            this.columnToAliasMap = new HashMap<String, String>();
            this.aliasToColumnMap = new HashMap<String, String>();
        }
        if (this.columnToAliasMap.get(originName) == null) {
            if (this.aliasToColumnMap.get(rawColumn.getAlias()) != null) {
                throw new LogicalOptimizeException(String.format(ALIAS_ERROR_MESSAGE1, rawColumn.getAlias()));
            }
            this.columnToAliasMap.put(originName, rawColumn.getAlias());
            this.aliasToColumnMap.put(rawColumn.getAlias(), originName);
        } else if (!this.columnToAliasMap.get(originName).equals(rawColumn.getAlias())) {
            throw new LogicalOptimizeException(String.format(ALIAS_ERROR_MESSAGE2, originName, this.columnToAliasMap.get(originName), rawColumn.getAlias()));
        }
    }

    public String generatePartialPathByLevel(boolean isCountStar, String[] nodes, int[] pathLevels) {
        HashSet<Integer> levelSet = new HashSet<Integer>();
        for (int level : pathLevels) {
            levelSet.add(level);
        }
        StringBuilder transformedPath = new StringBuilder();
        transformedPath.append(nodes[0]).append(".");
        for (int k = 1; k < nodes.length - 1; ++k) {
            if (levelSet.contains(k)) {
                transformedPath.append(nodes[k]);
            } else {
                transformedPath.append("*");
            }
            transformedPath.append(".");
        }
        if (isCountStar) {
            transformedPath.append("*");
        } else {
            transformedPath.append(nodes[nodes.length - 1]);
        }
        return transformedPath.toString();
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.seriesLimit, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.seriesOffset, (ByteBuffer)byteBuffer);
        if (this.limitPaths == null) {
            ReadWriteIOUtils.write((int)-1, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((int)this.limitPaths.size(), (ByteBuffer)byteBuffer);
            for (String limitPath : this.limitPaths) {
                ReadWriteIOUtils.write((String)limitPath, (ByteBuffer)byteBuffer);
            }
        }
        if (this.offsetPaths == null) {
            ReadWriteIOUtils.write((int)-1, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((int)this.offsetPaths.size(), (ByteBuffer)byteBuffer);
            for (String offsetPath : this.offsetPaths) {
                ReadWriteIOUtils.write((String)offsetPath, (ByteBuffer)byteBuffer);
            }
        }
        if (this.levels == null) {
            ReadWriteIOUtils.write((int)-1, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((int)this.levels.length, (ByteBuffer)byteBuffer);
            for (Object level : (Object)this.levels) {
                ReadWriteIOUtils.write((int)level, (ByteBuffer)byteBuffer);
            }
        }
        ReadWriteIOUtils.write((int)this.prevSize, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write(this.groupedPathMap, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write(this.columnToAliasMap, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write(this.aliasToColumnMap, (ByteBuffer)byteBuffer);
    }

    public static GroupByLevelController deserialize(ByteBuffer byteBuffer) {
        int seriesLimit = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        int seriesOffset = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        int limitPathSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashSet<String> limitPaths = null;
        if (limitPathSize != -1) {
            limitPaths = new HashSet<String>();
            for (int i = 0; i < limitPathSize; ++i) {
                limitPaths.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
            }
        }
        int offsetPathSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashSet<String> offsetPaths = null;
        if (offsetPathSize != -1) {
            offsetPaths = new HashSet<String>();
            for (int i = 0; i < offsetPathSize; ++i) {
                offsetPaths.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
            }
        }
        int levelSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        int[] levels = null;
        if (levelSize != -1) {
            levels = new int[levelSize];
            for (int i = 0; i < levelSize; ++i) {
                levels[i] = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            }
        }
        int prevSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        Map groupedPathMap = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
        Map columnToAliasMap = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
        Map aliasToColumnMap = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
        GroupByLevelController groupByLevelController = new GroupByLevelController(seriesLimit, levels);
        groupByLevelController.limitPaths = limitPaths;
        groupByLevelController.aliasToColumnMap = aliasToColumnMap;
        groupByLevelController.columnToAliasMap = columnToAliasMap;
        groupByLevelController.groupedPathMap = groupedPathMap;
        groupByLevelController.offsetPaths = offsetPaths;
        groupByLevelController.prevSize = prevSize;
        groupByLevelController.seriesOffset = seriesOffset;
        return groupByLevelController;
    }
}

