/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PruneTemplatePlan
extends PhysicalPlan {
    String name;
    String[] prunedMeasurements;

    public PruneTemplatePlan() {
        super(Operator.OperatorType.PRUNE_TEMPLATE);
    }

    public PruneTemplatePlan(String name, List<String> prunedMeasurements) {
        super(Operator.OperatorType.PRUNE_TEMPLATE);
        this.name = name;
        this.prunedMeasurements = prunedMeasurements.toArray(new String[0]);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getPrunedMeasurements() {
        return Arrays.asList(this.prunedMeasurements);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.PRUNE_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.name, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)this.prunedMeasurements.length, (ByteBuffer)buffer);
        for (String measurement : this.prunedMeasurements) {
            ReadWriteIOUtils.write((String)measurement, (ByteBuffer)buffer);
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.name = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.prunedMeasurements = new String[size];
        for (int i = 0; i < size; ++i) {
            this.prunedMeasurements[i] = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }
        this.index = buffer.getLong();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.PRUNE_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.name, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.prunedMeasurements.length, (OutputStream)stream);
        for (String measurement : this.prunedMeasurements) {
            ReadWriteIOUtils.write((String)measurement, (OutputStream)stream);
        }
        stream.writeLong(this.index);
    }

    public List<PartialPath> getPaths() {
        return null;
    }
}

