/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.utils.Pair;

public class CreatePipePlan
extends PhysicalPlan {
    private String pipeName;
    private String pipeSinkName;
    private long dataStartTimestamp;
    private List<Pair<String, String>> pipeAttributes;

    public CreatePipePlan(String pipeName, String pipeSinkName) {
        super(Operator.OperatorType.CREATE_PIPE);
        this.pipeName = pipeName;
        this.pipeSinkName = pipeSinkName;
        this.dataStartTimestamp = 0L;
        this.pipeAttributes = new ArrayList<Pair<String, String>>();
    }

    public void setDataStartTimestamp(long dataStartTimestamp) {
        this.dataStartTimestamp = dataStartTimestamp;
    }

    public void addPipeAttribute(String attr, String value) {
        this.pipeAttributes.add((Pair<String, String>)new Pair((Object)attr, (Object)value));
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public String getPipeSinkName() {
        return this.pipeSinkName;
    }

    public long getDataStartTimestamp() {
        return this.dataStartTimestamp;
    }

    public List<Pair<String, String>> getPipeAttributes() {
        return this.pipeAttributes;
    }

    @Override
    public List<? extends PartialPath> getPaths() {
        return Collections.emptyList();
    }

    public static CreatePipePlan parseString(String parsedString) throws IOException {
        String[] attributes = parsedString.split(",");
        if (attributes.length < 4) {
            throw new IOException("Parsing CreatePipePlan error. Attributes is less than expected.");
        }
        CreatePipePlan plan = new CreatePipePlan(attributes[0], attributes[1]);
        plan.setDataStartTimestamp(Long.parseLong(attributes[2]));
        int size = Integer.parseInt(attributes[3]) << 1;
        if (attributes.length != size + 4) {
            throw new IOException("Parsing CreatePipePlan error. Attributes number is wrong.");
        }
        for (int i = 0; i < size; i += 2) {
            plan.addPipeAttribute(attributes[i + 4], attributes[i + 5]);
        }
        return plan;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.pipeName).append(",");
        builder.append(this.pipeSinkName).append(",");
        builder.append(this.dataStartTimestamp).append(",");
        builder.append(this.pipeAttributes.size()).append(",");
        for (int i = 0; i < this.pipeAttributes.size(); ++i) {
            builder.append((String)this.pipeAttributes.get((int)i).left).append(",");
            builder.append((String)this.pipeAttributes.get((int)i).right).append(",");
        }
        return builder.toString();
    }
}

