/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.SpecialClauseComponent;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.thrift.TException;

public abstract class QueryPlan
extends PhysicalPlan {
    public static final String WITHOUT_NULL_FILTER_ERROR_MESSAGE = "The without null columns don't match the columns queried. If there is an alias, please use the alias.";
    protected List<ResultColumn> resultColumns = null;
    protected List<MeasurementPath> paths = null;
    private boolean alignByTime = true;
    private int rowLimit = 0;
    private int rowOffset = 0;
    private boolean ascending = true;
    private final Map<String, Integer> pathToIndex = new HashMap<String, Integer>();
    protected Set<Integer> withoutNullColumnsIndex;
    private boolean enableRedirect = false;
    private boolean enableTracing = false;
    private boolean withoutAnyNull;
    private boolean withoutAllNull;

    public QueryPlan() {
        super(Operator.OperatorType.QUERY);
        this.setQuery(true);
    }

    public Set<Integer> getWithoutNullColumnsIndex() {
        return this.withoutNullColumnsIndex;
    }

    public abstract void deduplicate(PhysicalGenerator var1) throws MetadataException;

    public abstract void convertSpecialClauseValues(SpecialClauseComponent var1) throws QueryProcessException;

    public TSExecuteStatementResp getTSExecuteStatementResp(boolean isJdbcQuery) throws TException, MetadataException {
        ArrayList<String> respColumns = new ArrayList<String>();
        ArrayList<String> columnsTypes = new ArrayList<String>();
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        ArrayList<String> respSgColumns = new ArrayList<String>();
        BitSet aliasMap = new BitSet();
        List<TSDataType> seriesTypes = this.getWideQueryHeaders(respColumns, respSgColumns, isJdbcQuery, aliasMap);
        for (TSDataType seriesType : seriesTypes) {
            columnsTypes.add(seriesType.toString());
        }
        resp.setColumnNameIndexMap(this.getPathToIndex());
        resp.setSgColumns(respSgColumns);
        ArrayList byteList = new ArrayList();
        byteList.addAll(Bytes.asList((byte[])aliasMap.toByteArray()));
        resp.setAliasColumns(byteList);
        resp.setColumns(respColumns);
        resp.setDataTypeList(columnsTypes);
        return resp;
    }

    public List<TSDataType> getWideQueryHeaders(List<String> respColumns, List<String> respSgColumns, boolean isJdbcQuery, BitSet aliasList) throws TException, MetadataException {
        ArrayList<TSDataType> seriesTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            if (isJdbcQuery) {
                String sgName = IoTDB.schemaProcessor.getBelongedStorageGroup(this.getPaths().get(i)).getFullPath();
                respSgColumns.add(sgName);
                if (this.resultColumns.get(i).getAlias() == null) {
                    respColumns.add(this.resultColumns.get(i).getResultColumnName().substring(sgName.length() + 1));
                } else {
                    aliasList.set(i);
                    respColumns.add(this.resultColumns.get(i).getResultColumnName());
                }
            } else {
                respColumns.add(this.resultColumns.get(i).getResultColumnName());
            }
            seriesTypes.add(this.paths.get(i).getSeriesType());
        }
        return seriesTypes;
    }

    public List<MeasurementPath> getPaths() {
        return this.paths;
    }

    @Override
    public void setPaths(List<PartialPath> paths) {
        ArrayList<MeasurementPath> measurementPaths = new ArrayList<MeasurementPath>();
        for (PartialPath path : paths) {
            measurementPaths.add((MeasurementPath)path);
        }
        this.paths = measurementPaths;
    }

    public List<TSDataType> getDataTypes() {
        return SchemaUtils.getSeriesTypesByPaths(this.paths);
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    public boolean hasLimit() {
        return this.rowLimit > 0;
    }

    public boolean isAlignByTime() {
        return this.alignByTime;
    }

    public void setAlignByTime(boolean align) {
        this.alignByTime = align;
    }

    public void setColumnNameToDatasetOutputIndex(String columnName, Integer index) {
        this.pathToIndex.put(columnName, index);
    }

    public boolean isGroupByLevel() {
        return false;
    }

    public Map<String, Integer> getPathToIndex() {
        return this.pathToIndex;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public String getColumnForReaderFromPath(PartialPath path, int pathIndex) {
        ResultColumn resultColumn = this.resultColumns.get(pathIndex);
        return resultColumn.hasAlias() ? resultColumn.getAlias() : path.getFullPath();
    }

    public String getColumnForDisplay(String columnForReader, int pathIndex) {
        return this.resultColumns.get(pathIndex).getResultColumnName();
    }

    public boolean isEnableRedirect() {
        return this.enableRedirect;
    }

    public void setEnableRedirect(boolean enableRedirect) {
        this.enableRedirect = enableRedirect;
    }

    public boolean isEnableTracing() {
        return this.enableTracing;
    }

    public void setEnableTracing(boolean enableTracing) {
        this.enableTracing = enableTracing;
    }

    public List<ResultColumn> getResultColumns() {
        return this.resultColumns;
    }

    public void setResultColumns(List<ResultColumn> resultColumns) {
        this.resultColumns = resultColumns;
    }

    public boolean isWithoutAnyNull() {
        return this.withoutAnyNull;
    }

    public void setWithoutAnyNull(boolean withoutAnyNull) {
        this.withoutAnyNull = withoutAnyNull;
    }

    public boolean isWithoutAllNull() {
        return this.withoutAllNull;
    }

    public void setWithoutAllNull(boolean withoutAllNull) {
        this.withoutAllNull = withoutAllNull;
    }
}

