/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class UnsetTemplateOperator
extends Operator {
    PartialPath prefixPath;
    String templateName;

    public UnsetTemplateOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.UNSET_TEMPLATE;
    }

    public PartialPath getPrefixPath() {
        return this.prefixPath;
    }

    public void setPrefixPath(PartialPath prefixPath) {
        this.prefixPath = prefixPath;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        try {
            return new UnsetTemplatePlan(this.prefixPath.toString(), this.templateName);
        }
        catch (IllegalPathException e) {
            throw new QueryProcessException((IoTDBException)e);
        }
    }
}

