/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SQLParserException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class InsertOperator
extends Operator {
    private PartialPath device;
    private long[] times;
    private String[] measurementList;
    private List<String[]> valueLists;
    private boolean isAligned;

    public InsertOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.INSERT;
    }

    public PartialPath getDevice() {
        return this.device;
    }

    public void setDevice(PartialPath device) {
        this.device = device;
    }

    public String[] getMeasurementList() {
        return this.measurementList;
    }

    public void setMeasurementList(String[] measurementList) {
        this.measurementList = measurementList;
    }

    public List<String[]> getValueLists() {
        return this.valueLists;
    }

    public void setValueLists(List<String[]> valueLists) {
        this.valueLists = valueLists;
    }

    public long[] getTimes() {
        return this.times;
    }

    public void setTimes(long[] times) {
        this.times = times;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public void setAligned(boolean aligned) {
        this.isAligned = aligned;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        int measurementsNum = this.measurementList.length;
        if (this.times.length == 1) {
            if (measurementsNum != this.valueLists.get(0).length) {
                throw new SQLParserException(String.format("the measurementList's size %d is not consistent with the valueList's size %d", measurementsNum, this.valueLists.get(0).length));
            }
            InsertRowPlan insertRowPlan = new InsertRowPlan(this.device, this.times[0], this.measurementList, this.valueLists.get(0));
            insertRowPlan.setAligned(this.isAligned);
            return insertRowPlan;
        }
        InsertRowsPlan insertRowsPlan = new InsertRowsPlan();
        for (int i = 0; i < this.times.length; ++i) {
            if (measurementsNum != this.valueLists.get(i).length) {
                throw new SQLParserException(String.format("the measurementList's size %d is not consistent with the valueList's size %d", measurementsNum, this.valueLists.get(i).length));
            }
            InsertRowPlan insertRowPlan = new InsertRowPlan(this.device, this.times[i], (String[])this.measurementList.clone(), this.valueLists.get(i));
            insertRowPlan.setAligned(this.isAligned);
            insertRowsPlan.addOneInsertRowPlan(insertRowPlan, i);
        }
        return insertRowsPlan;
    }
}

