/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.component;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.statement.StatementNode;
import org.apache.iotdb.db.mpp.plan.statement.component.FilterNullPolicy;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FilterNullComponent
extends StatementNode {
    FilterNullPolicy filterNullPolicy = FilterNullPolicy.NO_FILTER;
    List<Expression> withoutNullColumns = new ArrayList<Expression>();

    public FilterNullPolicy getWithoutPolicyType() {
        return this.filterNullPolicy;
    }

    public void setWithoutPolicyType(FilterNullPolicy filterNullPolicy) {
        this.filterNullPolicy = filterNullPolicy;
    }

    public void addWithoutNullColumn(Expression e) {
        this.withoutNullColumns.add(e);
    }

    public List<Expression> getWithoutNullColumns() {
        return this.withoutNullColumns;
    }

    public void setWithoutNullColumns(List<Expression> withoutNullColumns) {
        this.withoutNullColumns = withoutNullColumns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterNullComponent that = (FilterNullComponent)o;
        return this.filterNullPolicy == that.filterNullPolicy && Objects.equals(this.withoutNullColumns, that.withoutNullColumns);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filterNullPolicy, this.withoutNullColumns});
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.filterNullPolicy.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.withoutNullColumns.size(), (ByteBuffer)byteBuffer);
        for (Expression expression : this.withoutNullColumns) {
            Expression.serialize(expression, byteBuffer);
        }
    }

    public static FilterNullComponent deserialize(ByteBuffer byteBuffer) {
        FilterNullPolicy filterNullPolicy = FilterNullPolicy.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        int withoutNullSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Expression> withoutNullColumns = new ArrayList<Expression>();
        for (int i = 0; i < withoutNullSize; ++i) {
            withoutNullColumns.add(Expression.deserialize(byteBuffer));
        }
        FilterNullComponent filterNullComponent = new FilterNullComponent();
        filterNullComponent.withoutNullColumns = withoutNullColumns;
        filterNullComponent.filterNullPolicy = filterNullPolicy;
        return filterNullComponent;
    }
}

