/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.SetThreadName;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.exception.mpp.FragmentInstanceDispatchException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.analyze.SchemaValidator;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.mpp.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.db.mpp.plan.scheduler.IFragInstanceDispatcher;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstance;
import org.apache.iotdb.mpp.rpc.thrift.TPlanNode;
import org.apache.iotdb.mpp.rpc.thrift.TSendFragmentInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendFragmentInstanceResp;
import org.apache.iotdb.mpp.rpc.thrift.TSendPlanNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendPlanNodeResp;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstanceDispatcherImpl
implements IFragInstanceDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(FragmentInstanceDispatcherImpl.class);
    private final ExecutorService executor;
    private final ExecutorService writeOperationExecutor;
    private final QueryType type;
    private final String localhostIpAddr;
    private final int localhostInternalPort;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager;

    public FragmentInstanceDispatcherImpl(QueryType type, ExecutorService executor, ExecutorService writeOperationExecutor, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager) {
        this.type = type;
        this.executor = executor;
        this.writeOperationExecutor = writeOperationExecutor;
        this.internalServiceClientManager = internalServiceClientManager;
        this.localhostIpAddr = IoTDBDescriptor.getInstance().getConfig().getInternalIp();
        this.localhostInternalPort = IoTDBDescriptor.getInstance().getConfig().getInternalPort();
    }

    @Override
    public Future<FragInstanceDispatchResult> dispatch(List<FragmentInstance> instances) {
        if (this.type == QueryType.READ) {
            return this.dispatchRead(instances);
        }
        return this.dispatchWriteSync(instances);
    }

    private Future<FragInstanceDispatchResult> dispatchRead(List<FragmentInstance> instances) {
        return this.executor.submit(() -> {
            for (FragmentInstance instance : instances) {
                boolean accepted = this.dispatchOneInstance(instance);
                if (accepted) continue;
                return new FragInstanceDispatchResult(false);
            }
            return new FragInstanceDispatchResult(true);
        });
    }

    private Future<FragInstanceDispatchResult> dispatchWrite(List<FragmentInstance> instances) {
        LinkedList<Future<Boolean>> futures = new LinkedList<Future<Boolean>>();
        for (FragmentInstance instance : instances) {
            futures.add(this.writeOperationExecutor.submit(() -> this.dispatchOneInstance(instance)));
        }
        SettableFuture resultFuture = SettableFuture.create();
        for (Future future : futures) {
            try {
                Boolean success = (Boolean)future.get();
                if (success.booleanValue()) continue;
                resultFuture.set((Object)new FragInstanceDispatchResult(false));
            }
            catch (InterruptedException | ExecutionException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                resultFuture.setException((Throwable)e);
            }
            break;
        }
        resultFuture.set((Object)new FragInstanceDispatchResult(true));
        return resultFuture;
    }

    private Future<FragInstanceDispatchResult> dispatchWriteSync(List<FragmentInstance> instances) {
        boolean result = true;
        try {
            for (FragmentInstance instance : instances) {
                if (this.dispatchOneInstance(instance)) continue;
                result = false;
                break;
            }
            return Futures.immediateFuture((Object)new FragInstanceDispatchResult(result));
        }
        catch (FragmentInstanceDispatchException e) {
            logger.error("cannot dispatch FI for write operation", (Throwable)e);
            return Futures.immediateFuture((Object)new FragInstanceDispatchResult(false));
        }
    }

    private boolean dispatchOneInstance(FragmentInstance instance) throws FragmentInstanceDispatchException {
        try (SetThreadName fragmentInstanceName = new SetThreadName(instance.getId().getFullId(), new Object[0]);){
            TEndPoint endPoint = instance.getHostDataNode().getInternalEndPoint();
            if (this.isDispatchedToLocal(endPoint)) {
                boolean bl = this.dispatchLocally(instance);
                return bl;
            }
            boolean bl = this.dispatchRemote(instance, endPoint);
            return bl;
        }
    }

    private boolean isDispatchedToLocal(TEndPoint endPoint) {
        return this.localhostIpAddr.equals(endPoint.getIp()) && this.localhostInternalPort == endPoint.port;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dispatchRemote(FragmentInstance instance, TEndPoint endPoint) throws FragmentInstanceDispatchException {
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.internalServiceClientManager.borrowClient((Object)endPoint);){
            switch (instance.getType()) {
                case READ: {
                    TSendFragmentInstanceReq sendFragmentInstanceReq = new TSendFragmentInstanceReq(new TFragmentInstance(instance.serializeToByteBuffer()), instance.getRegionReplicaSet().getRegionId());
                    TSendFragmentInstanceResp sendFragmentInstanceResp = client.sendFragmentInstance(sendFragmentInstanceReq);
                    boolean bl = sendFragmentInstanceResp.accepted;
                    return bl;
                }
                case WRITE: {
                    TSendPlanNodeReq sendPlanNodeReq = new TSendPlanNodeReq(new TPlanNode(instance.getFragment().getRoot().serializeToByteBuffer()), instance.getRegionReplicaSet().getRegionId());
                    TSendPlanNodeResp sendPlanNodeResp = client.sendPlanNode(sendPlanNodeReq);
                    boolean bl = sendPlanNodeResp.accepted;
                    return bl;
                }
            }
            return false;
        }
        catch (IOException | TException e) {
            logger.error("can't connect to node {}", (Object)endPoint, (Object)e);
            throw new FragmentInstanceDispatchException(e);
        }
    }

    private boolean dispatchLocally(FragmentInstance instance) throws FragmentInstanceDispatchException {
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)instance.getRegionReplicaSet().getRegionId());
        switch (instance.getType()) {
            case READ: {
                ConsensusReadResponse readResponse = groupId instanceof DataRegionId ? DataRegionConsensusImpl.getInstance().read(groupId, (IConsensusRequest)instance) : SchemaRegionConsensusImpl.getInstance().read(groupId, (IConsensusRequest)instance);
                if (!readResponse.isSuccess()) {
                    logger.error("dispatch FragmentInstance {} locally failed because {}", (Object)instance, (Object)readResponse.getException());
                    return false;
                }
                return !((FragmentInstanceInfo)readResponse.getDataset()).getState().isFailed();
            }
            case WRITE: {
                PlanNode planNode = instance.getFragment().getRoot();
                boolean hasFailedMeasurement = false;
                if (planNode instanceof InsertNode) {
                    InsertNode insertNode = (InsertNode)planNode;
                    try {
                        SchemaValidator.validate(insertNode);
                    }
                    catch (SemanticException e) {
                        throw new FragmentInstanceDispatchException(e);
                    }
                    hasFailedMeasurement = insertNode.hasFailedMeasurements();
                    if (hasFailedMeasurement) {
                        logger.warn("Fail to insert measurements {} caused by {}", insertNode.getFailedMeasurements(), insertNode.getFailedMessages());
                    }
                }
                ConsensusWriteResponse writeResponse = groupId instanceof DataRegionId ? DataRegionConsensusImpl.getInstance().write(groupId, (IConsensusRequest)planNode) : SchemaRegionConsensusImpl.getInstance().write(groupId, (IConsensusRequest)planNode);
                return !hasFailedMeasurement && TSStatusCode.SUCCESS_STATUS.getStatusCode() == writeResponse.getStatus().getCode();
            }
        }
        throw new UnsupportedOperationException(String.format("unknown query type [%s]", new Object[]{instance.getType()}));
    }

    @Override
    public void abort() {
    }
}

