/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import io.airlift.concurrent.SetThreadName;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.db.mpp.execution.QueryStateMachine;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.scheduler.AbstractFragInsStateTracker;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedRateFragInsStateTracker
extends AbstractFragInsStateTracker {
    private static final Logger logger = LoggerFactory.getLogger(FixedRateFragInsStateTracker.class);
    private static final long STATE_FETCH_INTERVAL_IN_MS = 500L;
    private ScheduledFuture<?> trackTask;

    public FixedRateFragInsStateTracker(QueryStateMachine stateMachine, ExecutorService executor, ScheduledExecutorService scheduledExecutor, List<FragmentInstance> instances, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager) {
        super(stateMachine, executor, scheduledExecutor, instances, internalServiceClientManager);
    }

    @Override
    public void start() {
        this.trackTask = ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.scheduledExecutor, this::fetchStateAndUpdate, (long)0L, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public void abort() {
        if (this.trackTask != null) {
            this.trackTask.cancel(true);
        }
    }

    private void fetchStateAndUpdate() {
        for (FragmentInstance instance : this.instances) {
            try {
                SetThreadName threadName = new SetThreadName(instance.getId().getFullId(), new Object[0]);
                Throwable throwable = null;
                try {
                    FragmentInstanceState state = this.fetchState(instance);
                    logger.info("State is {}", (Object)state);
                    if (state == null) continue;
                    this.stateMachine.updateFragInstanceState(instance.getId(), state);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (threadName == null) continue;
                    if (throwable != null) {
                        try {
                            threadName.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    threadName.close();
                }
            }
            catch (IOException | TException e) {
                logger.error("error happened while fetching query state", e);
            }
        }
    }
}

