/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.db.mpp.execution.QueryStateMachine;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.scheduler.IFragInstanceStateTracker;
import org.apache.iotdb.mpp.rpc.thrift.TFetchFragmentInstanceStateReq;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceStateResp;
import org.apache.thrift.TException;

public abstract class AbstractFragInsStateTracker
implements IFragInstanceStateTracker {
    protected QueryStateMachine stateMachine;
    protected ExecutorService executor;
    protected ScheduledExecutorService scheduledExecutor;
    protected List<FragmentInstance> instances;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager;

    public AbstractFragInsStateTracker(QueryStateMachine stateMachine, ExecutorService executor, ScheduledExecutorService scheduledExecutor, List<FragmentInstance> instances, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager) {
        this.stateMachine = stateMachine;
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
        this.instances = instances;
        this.internalServiceClientManager = internalServiceClientManager;
    }

    @Override
    public abstract void start();

    @Override
    public abstract void abort();

    protected FragmentInstanceState fetchState(FragmentInstance instance) throws TException, IOException {
        TEndPoint endPoint = instance.getHostDataNode().internalEndPoint;
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.internalServiceClientManager.borrowClient((Object)endPoint);){
            TFragmentInstanceStateResp resp = client.fetchFragmentInstanceState(new TFetchFragmentInstanceStateReq(this.getTId(instance)));
            FragmentInstanceState fragmentInstanceState = FragmentInstanceState.valueOf(resp.state);
            return fragmentInstanceState;
        }
    }

    private TFragmentInstanceId getTId(FragmentInstance instance) {
        return new TFragmentInstanceId(instance.getId().getQueryId().getId(), instance.getId().getFragmentId().getId(), instance.getId().getInstanceId());
    }
}

