/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.statement.component.FilterNullPolicy;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FilterNullParameter {
    private FilterNullPolicy filterNullPolicy;
    private List<Expression> filterNullColumns;

    public FilterNullParameter() {
    }

    public FilterNullParameter(FilterNullPolicy filterNullPolicy, List<Expression> filterNullColumns) {
        this.filterNullPolicy = filterNullPolicy;
        this.filterNullColumns = filterNullColumns;
    }

    public FilterNullPolicy getFilterNullPolicy() {
        return this.filterNullPolicy;
    }

    public List<Expression> getFilterNullColumns() {
        return this.filterNullColumns;
    }

    public void setFilterNullPolicy(FilterNullPolicy filterNullPolicy) {
        this.filterNullPolicy = filterNullPolicy;
    }

    public void setFilterNullColumns(List<Expression> filterNullColumns) {
        this.filterNullColumns = filterNullColumns;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.filterNullPolicy.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.filterNullColumns.size(), (ByteBuffer)byteBuffer);
        for (Expression filterNullColumn : this.filterNullColumns) {
            Expression.serialize(filterNullColumn, byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.filterNullPolicy.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.filterNullColumns.size(), (OutputStream)stream);
        for (Expression filterNullColumn : this.filterNullColumns) {
            Expression.serialize(filterNullColumn, stream);
        }
    }

    public static FilterNullParameter deserialize(ByteBuffer byteBuffer) {
        FilterNullPolicy filterNullPolicy = FilterNullPolicy.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Expression> filterNullColumns = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            filterNullColumns.add(Expression.deserialize(byteBuffer));
        }
        return new FilterNullParameter(filterNullPolicy, filterNullColumns);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterNullParameter that = (FilterNullParameter)o;
        return this.filterNullPolicy == that.filterNullPolicy && Objects.equals(this.filterNullColumns, that.filterNullColumns);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filterNullPolicy, this.filterNullColumns});
    }
}

