/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ProcessNode;
import org.apache.iotdb.db.mpp.plan.statement.component.OrderBy;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SortNode
extends ProcessNode {
    private PlanNode child;
    private final OrderBy sortOrder;

    public SortNode(PlanNodeId id, OrderBy sortOrder) {
        super(id);
        this.sortOrder = sortOrder;
    }

    public SortNode(PlanNodeId id, PlanNode child, OrderBy sortOrder) {
        this(id, sortOrder);
        this.child = child;
    }

    public OrderBy getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of((Object)this.child);
    }

    @Override
    public void addChild(PlanNode child) {
        this.child = child;
    }

    @Override
    public int allowedChildCount() {
        return 1;
    }

    @Override
    public PlanNode clone() {
        return new SortNode(this.getPlanNodeId(), this.sortOrder);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.child.getOutputColumnNames();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSort(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.SORT.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.sortOrder.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.SORT.serialize(stream);
        ReadWriteIOUtils.write((int)this.sortOrder.ordinal(), (OutputStream)stream);
    }

    public static SortNode deserialize(ByteBuffer byteBuffer) {
        OrderBy orderBy = OrderBy.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SortNode(planNodeId, orderBy);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SortNode sortNode = (SortNode)o;
        return this.child.equals(sortNode.child) && this.sortOrder == sortNode.sortOrder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.child, this.sortOrder});
    }
}

