/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.executor;

import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.consensus.PartitionRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.rpc.thrift.TClusterNodeInfos;
import org.apache.iotdb.confignode.rpc.thrift.TCountStorageGroupResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteStorageGroupsReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetStorageGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchemaResp;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.client.DataNodeClientPoolFactory;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.CountStorageGroupTask;
import org.apache.iotdb.db.mpp.plan.execution.config.SetStorageGroupTask;
import org.apache.iotdb.db.mpp.plan.execution.config.ShowClusterTask;
import org.apache.iotdb.db.mpp.plan.execution.config.ShowRegionTask;
import org.apache.iotdb.db.mpp.plan.execution.config.ShowStorageGroupTask;
import org.apache.iotdb.db.mpp.plan.execution.config.ShowTTLTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowRegionStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConfigTaskExecutor
implements IConfigTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterConfigTaskExecutor.class);
    private static final IClientManager<PartitionRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.ConfigNodeClientPoolFactory());

    public static ClusterConfigTaskExecutor getInstance() {
        return ClusterConfigTaskExecutorHolder.INSTANCE;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setStorageGroup(SetStorageGroupStatement setStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        TStorageGroupSchema storageGroupSchema = SetStorageGroupTask.constructStorageGroupSchema(setStorageGroupStatement);
        TSetStorageGroupReq req = new TSetStorageGroupReq(storageGroupSchema);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSStatus tsStatus = configNodeClient.setStorageGroup(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.error("Failed to execute set storage group {} in config node, status is {}.", (Object)setStorageGroupStatement.getStorageGroupPath(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showStorageGroup(ShowStorageGroupStatement showStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        List<String> storageGroupPathPattern = Arrays.asList(showStorageGroupStatement.getPathPattern().getNodes());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TStorageGroupSchemaResp resp = client.getMatchedStorageGroupSchemas(storageGroupPathPattern);
            Map storageGroupSchemaMap = resp.getStorageGroupSchemaMap();
            ShowStorageGroupTask.buildTSBlock(storageGroupSchemaMap, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> countStorageGroup(CountStorageGroupStatement countStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        List<String> storageGroupPathPattern = Arrays.asList(countStorageGroupStatement.getPartialPath().getNodes());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TCountStorageGroupResp resp = client.countMatchedStorageGroups(storageGroupPathPattern);
            int storageGroupNum = resp.getCount();
            CountStorageGroupTask.buildTSBlock(storageGroupNum, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createFunction(String udfName, String className, List<String> uris) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSStatus executionStatus = client.createFunction(new TCreateFunctionReq(udfName, className, uris));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.error("[{}] Failed to create function {}({}) in config node, URI: {}.", new Object[]{executionStatus, udfName, className, uris});
                future.setException((Throwable)new StatementExecutionException(executionStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteStorageGroup(DeleteStorageGroupStatement deleteStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        TDeleteStorageGroupsReq req = new TDeleteStorageGroupsReq(deleteStorageGroupStatement.getPrefixPath());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSStatus tsStatus = client.deleteStorageGroups(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.error("Failed to execute delete storage group {} in config node, status is {}.", deleteStorageGroupStatement.getPrefixPath(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropFunction(String udfName) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSStatus executionStatus = client.dropFunction(new TDropFunctionReq(udfName));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.error("[{}] Failed to drop function {} in config node.", (Object)executionStatus, (Object)udfName);
                future.setException((Throwable)new StatementExecutionException(executionStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setTTL(SetTTLStatement setTTLStatement, String taskName) {
        SettableFuture future = SettableFuture.create();
        TSetTTLReq setTTLReq = new TSetTTLReq(setTTLStatement.getStorageGroupPath().getFullPath(), setTTLStatement.getTTL());
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSStatus tsStatus = configNodeClient.setTTL(setTTLReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.error("Failed to execute {} {} in config node, status is {}.", new Object[]{taskName, setTTLStatement.getStorageGroupPath(), tsStatus});
                future.setException((Throwable)new StatementExecutionException(tsStatus));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> flush(TFlushReq tFlushReq) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TSStatus tsStatus = client.flush(tFlushReq);
            if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            } else {
                future.setException((Throwable)new StatementExecutionException(tsStatus));
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showCluster() {
        SettableFuture future = SettableFuture.create();
        TClusterNodeInfos clusterNodeInfos = new TClusterNodeInfos();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            clusterNodeInfos = client.getAllClusterNodeInfos();
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        ShowClusterTask.buildTSBlock(clusterNodeInfos, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showTTL(ShowTTLStatement showTTLStatement) {
        SettableFuture future = SettableFuture.create();
        List<PartialPath> storageGroupPaths = showTTLStatement.getPaths();
        HashMap<String, Long> storageGroupToTTL = new HashMap<String, Long>();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            if (showTTLStatement.isAll()) {
                List<String> allStorageGroupPathPattern = Arrays.asList("root", "**");
                TStorageGroupSchemaResp resp = client.getMatchedStorageGroupSchemas(allStorageGroupPathPattern);
                for (Map.Entry entry : resp.getStorageGroupSchemaMap().entrySet()) {
                    storageGroupToTTL.put((String)entry.getKey(), ((TStorageGroupSchema)entry.getValue()).getTTL());
                }
            } else {
                for (PartialPath storageGroupPath : storageGroupPaths) {
                    List<String> storageGroupPathPattern = Arrays.asList(storageGroupPath.getNodes());
                    TStorageGroupSchemaResp resp = client.getMatchedStorageGroupSchemas(storageGroupPathPattern);
                    for (Map.Entry entry : resp.getStorageGroupSchemaMap().entrySet()) {
                        if (storageGroupToTTL.containsKey(entry.getKey())) continue;
                        storageGroupToTTL.put((String)entry.getKey(), ((TStorageGroupSchema)entry.getValue()).getTTL());
                    }
                }
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        ShowTTLTask.buildTSBlock(storageGroupToTTL, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showRegion(ShowRegionStatement showRegionStatement) {
        SettableFuture future = SettableFuture.create();
        TShowRegionResp showRegionResp = new TShowRegionResp();
        TShowRegionReq showRegionReq = new TShowRegionReq();
        showRegionReq.setConsensusGroupType(showRegionStatement.getRegionType());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            showRegionResp = client.showRegion(showRegionReq);
            if (showRegionResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new StatementExecutionException(showRegionResp.getStatus()));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (IOException | TException e) {
            future.setException(e);
        }
        ShowRegionTask.buildTSBlock(showRegionResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    private static final class ClusterConfigTaskExecutorHolder {
        private static final ClusterConfigTaskExecutor INSTANCE = new ClusterConfigTaskExecutor();

        private ClusterConfigTaskExecutorHolder() {
        }
    }
}

