/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Map;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.header.HeaderConstant;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowStorageGroupStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowStorageGroupTask
implements IConfigTask {
    private ShowStorageGroupStatement showStorageGroupStatement;

    public ShowStorageGroupTask(ShowStorageGroupStatement showStorageGroupStatement) {
        this.showStorageGroupStatement = showStorageGroupStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showStorageGroup(this.showStorageGroupStatement);
    }

    public static void buildTSBlock(Map<String, TStorageGroupSchema> storageGroupSchemaMap, SettableFuture<ConfigTaskResult> future) {
        TsBlockBuilder builder = new TsBlockBuilder(HeaderConstant.showStorageGroupHeader.getRespDataTypes());
        for (Map.Entry<String, TStorageGroupSchema> entry : storageGroupSchemaMap.entrySet()) {
            String storageGroup = entry.getKey();
            TStorageGroupSchema storageGroupSchema = entry.getValue();
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(storageGroup));
            if (Long.MAX_VALUE == storageGroupSchema.getTTL()) {
                builder.getColumnBuilder(1).appendNull();
            } else {
                builder.getColumnBuilder(1).writeLong(storageGroupSchema.getTTL());
            }
            builder.getColumnBuilder(2).writeInt(storageGroupSchema.getSchemaReplicationFactor());
            builder.getColumnBuilder(3).writeInt(storageGroupSchema.getDataReplicationFactor());
            builder.getColumnBuilder(4).writeLong(storageGroupSchema.getTimePartitionInterval());
            builder.declarePosition();
        }
        DatasetHeader datasetHeader = HeaderConstant.showStorageGroupHeader;
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

