/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateFunctionStatement;

public class CreateFunctionTask
implements IConfigTask {
    private final String udfName;
    private final String className;
    private final List<String> uris;

    public CreateFunctionTask(CreateFunctionStatement createFunctionStatement) {
        this.udfName = createFunctionStatement.getUdfName();
        this.className = createFunctionStatement.getClassName();
        this.uris = createFunctionStatement.getUris().stream().map(URI::toString).collect(Collectors.toList());
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.createFunction(this.udfName, this.className, this.uris);
    }
}

