/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.mpp.plan.Metric;

public class StepTracker {
    private static final ThreadLocal<Map<String, Metric>> metrics = new ThreadLocal();

    public static void trace(String stepName, long startTime, long endTime) {
        if (metrics.get() == null) {
            metrics.set(new HashMap());
        }
        metrics.get().computeIfAbsent(stepName, Metric::new).trace(startTime, endTime);
        metrics.get().get(stepName).tryPrint();
    }

    public static void cleanup() {
        metrics.set(null);
    }
}

