/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class SchemaFetchMergeOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final List<Operator> children;
    private final int childrenCount;
    private int currentIndex;

    public SchemaFetchMergeOperator(OperatorContext operatorContext, List<Operator> children) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.childrenCount = children.size();
        this.currentIndex = 0;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        if (this.children.get(this.currentIndex).hasNext()) {
            return this.children.get(this.currentIndex).next();
        }
        ++this.currentIndex;
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.childrenCount;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.children.get(this.currentIndex).isBlocked();
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }
}

