/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.header.HeaderConstant;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class NodePathsSchemaScanOperator
implements SourceOperator {
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final PartialPath partialPath;
    private final int level;
    private boolean isFinished;

    public NodePathsSchemaScanOperator(PlanNodeId sourceId, OperatorContext operatorContext, PartialPath partialPath, int level) {
        this.sourceId = sourceId;
        this.operatorContext = operatorContext;
        this.partialPath = partialPath;
        this.level = level;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        Set<String> nodePaths;
        this.isFinished = true;
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(HeaderConstant.showChildPathsHeader.getRespDataTypes());
        try {
            nodePaths = -1 == this.level ? ((SchemaDriverContext)this.operatorContext.getInstanceContext().getDriverContext()).getSchemaRegion().getChildNodePathInNextLevel(this.partialPath) : ((SchemaDriverContext)this.operatorContext.getInstanceContext().getDriverContext()).getSchemaRegion().getNodesListInGivenLevel(this.partialPath, this.level, true, null).stream().map(PartialPath::getFullPath).collect(Collectors.toSet());
        }
        catch (MetadataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        nodePaths.forEach(path -> {
            tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
            tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(path));
            tsBlockBuilder.declarePosition();
        });
        return tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }
}

