/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.AggregationOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public class RawDataAggregationOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final List<Aggregator> aggregators;
    private final Operator child;
    private final boolean ascending;
    private ITimeRangeIterator timeRangeIterator;
    private TimeRange curTimeRange;
    private TsBlock preCachedData;
    private final TsBlockBuilder tsBlockBuilder;

    public RawDataAggregationOperator(OperatorContext operatorContext, List<Aggregator> aggregators, Operator child, boolean ascending, GroupByTimeParameter groupByTimeParameter) {
        this.operatorContext = operatorContext;
        this.aggregators = aggregators;
        this.child = child;
        this.ascending = ascending;
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Aggregator aggregator : aggregators) {
            dataTypes.addAll(Arrays.asList(aggregator.getOutputType()));
        }
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.timeRangeIterator = SeriesAggregationScanOperator.initTimeRangeIterator(groupByTimeParameter, ascending, true);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() {
        if (this.curTimeRange == null && this.timeRangeIterator.hasNextTimeRange()) {
            this.curTimeRange = this.timeRangeIterator.nextTimeRange();
            for (Aggregator aggregator : this.aggregators) {
                aggregator.reset();
                aggregator.updateTimeRange(this.curTimeRange);
            }
        }
        boolean canCallNext = true;
        while (!this.calcFromCacheData(this.curTimeRange)) {
            this.preCachedData = null;
            if (this.child.hasNext() && canCallNext) {
                this.preCachedData = this.child.next();
                canCallNext = false;
                continue;
            }
            if (!this.child.hasNext()) break;
            return null;
        }
        this.curTimeRange = null;
        return AggregationOperator.updateResultTsBlockFromAggregators(this.tsBlockBuilder, this.aggregators, this.timeRangeIterator);
    }

    @Override
    public boolean hasNext() {
        return this.curTimeRange != null || this.timeRangeIterator.hasNextTimeRange();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    private boolean calcFromCacheData(TimeRange curTimeRange) {
        if (this.preCachedData == null || this.preCachedData.isEmpty()) {
            return false;
        }
        if (RawDataAggregationOperator.satisfied(this.preCachedData, curTimeRange, this.ascending)) {
            if (this.ascending && this.preCachedData.getStartTime() < curTimeRange.getMin() || !this.ascending && this.preCachedData.getStartTime() > curTimeRange.getMax()) {
                this.preCachedData = RawDataAggregationOperator.skipOutOfTimeRangePoints(this.preCachedData, curTimeRange, this.ascending);
            }
            int lastReadRowIndex = 0;
            for (Aggregator aggregator : this.aggregators) {
                if (aggregator.hasFinalResult()) continue;
                lastReadRowIndex = Math.max(lastReadRowIndex, aggregator.processTsBlock(this.preCachedData));
            }
            this.preCachedData = lastReadRowIndex >= this.preCachedData.getPositionCount() ? null : this.preCachedData.subTsBlock(lastReadRowIndex);
        }
        return this.preCachedData != null && (!this.ascending ? this.preCachedData.getEndTime() < curTimeRange.getMin() : this.preCachedData.getEndTime() > curTimeRange.getMax()) || RawDataAggregationOperator.isEndCalc(this.aggregators);
    }

    public static TsBlock skipOutOfTimeRangePoints(TsBlock tsBlock, TimeRange curTimeRange, boolean ascending) {
        TimeColumn timeColumn = tsBlock.getTimeColumn();
        long targetTime = ascending ? curTimeRange.getMin() : curTimeRange.getMax();
        int left = 0;
        int right = timeColumn.getPositionCount() - 1;
        while (left < right) {
            int mid = left + right >> 1;
            if (timeColumn.getLongWithoutCheck(mid) < targetTime) {
                if (ascending) {
                    left = mid + 1;
                    continue;
                }
                right = mid;
                continue;
            }
            if (timeColumn.getLongWithoutCheck(mid) > targetTime) {
                if (ascending) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
                continue;
            }
            if (timeColumn.getLongWithoutCheck(mid) != targetTime) continue;
            return tsBlock.subTsBlock(mid);
        }
        return tsBlock.subTsBlock(left);
    }

    public static boolean satisfied(TsBlock tsBlock, TimeRange timeRange, boolean ascending) {
        TsBlock.TsBlockSingleColumnIterator tsBlockIterator = tsBlock.getTsBlockSingleColumnIterator();
        if (tsBlockIterator == null || !tsBlockIterator.hasNext()) {
            return false;
        }
        return ascending ? tsBlockIterator.getEndTime() >= timeRange.getMin() && tsBlockIterator.currentTime() <= timeRange.getMax() : tsBlockIterator.getEndTime() <= timeRange.getMax() && tsBlockIterator.currentTime() >= timeRange.getMin();
    }

    public static boolean isEndCalc(List<Aggregator> aggregators) {
        for (Aggregator aggregator : aggregators) {
            if (aggregator.hasFinalResult()) continue;
            return false;
        }
        return true;
    }
}

