/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class AggregationOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final List<Aggregator> aggregators;
    private final List<Operator> children;
    private final int inputOperatorsCount;
    private final TsBlock[] inputTsBlocks;
    private final TsBlockBuilder tsBlockBuilder;
    private final ITimeRangeIterator timeRangeIterator;
    private TimeRange curTimeRange;

    public AggregationOperator(OperatorContext operatorContext, List<Aggregator> aggregators, List<Operator> children, boolean ascending, GroupByTimeParameter groupByTimeParameter, boolean outputPartialTimeWindow) {
        this.operatorContext = operatorContext;
        this.aggregators = aggregators;
        this.children = children;
        this.inputOperatorsCount = children.size();
        this.inputTsBlocks = new TsBlock[this.inputOperatorsCount];
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Aggregator aggregator : aggregators) {
            dataTypes.addAll(Arrays.asList(aggregator.getOutputType()));
        }
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.timeRangeIterator = SeriesAggregationScanOperator.initTimeRangeIterator(groupByTimeParameter, ascending, outputPartialTimeWindow);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            ListenableFuture<?> blocked = this.children.get(i).isBlocked();
            if (blocked.isDone()) continue;
            return blocked;
        }
        return NOT_BLOCKED;
    }

    @Override
    public TsBlock next() {
        if (this.curTimeRange == null && this.timeRangeIterator.hasNextTimeRange()) {
            this.curTimeRange = this.timeRangeIterator.nextTimeRange();
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.inputTsBlocks[i] != null) continue;
            this.inputTsBlocks[i] = this.children.get(i).next();
            if (this.inputTsBlocks[i] != null) continue;
            return null;
        }
        for (Aggregator aggregator : this.aggregators) {
            aggregator.reset();
            aggregator.processTsBlocks(this.inputTsBlocks);
        }
        this.curTimeRange = null;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            this.inputTsBlocks[i] = null;
        }
        return AggregationOperator.updateResultTsBlockFromAggregators(this.tsBlockBuilder, this.aggregators, this.timeRangeIterator);
    }

    @Override
    public boolean hasNext() {
        return this.curTimeRange != null || this.timeRangeIterator.hasNextTimeRange();
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    public static TsBlock updateResultTsBlockFromAggregators(TsBlockBuilder tsBlockBuilder, List<? extends Aggregator> aggregators, ITimeRangeIterator timeRangeIterator) {
        tsBlockBuilder.reset();
        TimeColumnBuilder timeColumnBuilder = tsBlockBuilder.getTimeColumnBuilder();
        timeColumnBuilder.writeLong(timeRangeIterator.currentOutputTime());
        ColumnBuilder[] columnBuilders = tsBlockBuilder.getValueColumnBuilders();
        int columnIndex = 0;
        for (Aggregator aggregator : aggregators) {
            ColumnBuilder[] columnBuilder = new ColumnBuilder[aggregator.getOutputType().length];
            columnBuilder[0] = columnBuilders[columnIndex++];
            if (columnBuilder.length > 1) {
                columnBuilder[1] = columnBuilders[columnIndex++];
            }
            aggregator.outputResult(columnBuilder);
        }
        tsBlockBuilder.declarePosition();
        return tsBlockBuilder.build();
    }
}

