/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.exchange;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.SetThreadName;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.mpp.execution.exchange.ISourceHandle;
import org.apache.iotdb.db.mpp.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.mpp.execution.exchange.SharedTsBlockQueue;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSourceHandle
implements ISourceHandle {
    private static final Logger logger = LoggerFactory.getLogger(LocalSourceHandle.class);
    private final TFragmentInstanceId remoteFragmentInstanceId;
    private final TFragmentInstanceId localFragmentInstanceId;
    private final String localPlanNodeId;
    private final MPPDataExchangeManager.SourceHandleListener sourceHandleListener;
    private final SharedTsBlockQueue queue;
    private boolean aborted = false;
    private int currSequenceId;
    private final String threadName;

    public LocalSourceHandle(TFragmentInstanceId remoteFragmentInstanceId, TFragmentInstanceId localFragmentInstanceId, String localPlanNodeId, SharedTsBlockQueue queue, MPPDataExchangeManager.SourceHandleListener sourceHandleListener) {
        this.remoteFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)remoteFragmentInstanceId);
        this.localFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)localFragmentInstanceId);
        this.localPlanNodeId = (String)Validate.notNull((Object)localPlanNodeId);
        this.queue = (SharedTsBlockQueue)Validate.notNull((Object)queue);
        this.queue.setSourceHandle(this);
        this.sourceHandleListener = (MPPDataExchangeManager.SourceHandleListener)Validate.notNull((Object)sourceHandleListener);
        this.threadName = MPPDataExchangeManager.createFullIdFrom(localFragmentInstanceId, localPlanNodeId + ".SourceHandle");
    }

    @Override
    public TFragmentInstanceId getLocalFragmentInstanceId() {
        return this.localFragmentInstanceId;
    }

    @Override
    public String getLocalPlanNodeId() {
        return this.localPlanNodeId;
    }

    @Override
    public long getBufferRetainedSizeInBytes() {
        return this.queue.getBufferRetainedSizeInBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TsBlock receive() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName, new Object[0]);){
            TsBlock tsBlock;
            if (this.aborted) {
                throw new IllegalStateException("Source handle is aborted.");
            }
            if (!this.queue.isBlocked().isDone()) {
                throw new IllegalStateException("Source handle is blocked.");
            }
            SharedTsBlockQueue sharedTsBlockQueue = this.queue;
            synchronized (sharedTsBlockQueue) {
                tsBlock = this.queue.remove();
            }
            if (tsBlock != null) {
                ++this.currSequenceId;
                logger.info("Receive {} TsdBlock, size is {}", (Object)this.currSequenceId, (Object)tsBlock.getRetainedSizeInBytes());
            }
            this.checkAndInvokeOnFinished();
            sharedTsBlockQueue = tsBlock;
            return sharedTsBlockQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            return this.queue.hasNoMoreTsBlocks() && this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndInvokeOnFinished() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            if (this.isFinished()) {
                LocalSourceHandle localSourceHandle = this;
                synchronized (localSourceHandle) {
                    this.sourceHandleListener.onFinished(this);
                }
            }
        }
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.aborted) {
            throw new IllegalStateException("Source handle is closed.");
        }
        return Futures.nonCancellationPropagating(this.queue.isBlocked());
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void abort() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName, new Object[0]);){
            logger.info("Source handle is being aborted.");
            SharedTsBlockQueue sharedTsBlockQueue = this.queue;
            synchronized (sharedTsBlockQueue) {
                LocalSourceHandle localSourceHandle = this;
                synchronized (localSourceHandle) {
                    if (this.aborted) {
                        return;
                    }
                    this.queue.destroy();
                    this.aborted = true;
                    this.sourceHandleListener.onAborted(this);
                }
            }
            logger.info("Source handle is aborted");
            return;
        }
    }

    public TFragmentInstanceId getRemoteFragmentInstanceId() {
        return this.remoteFragmentInstanceId;
    }

    SharedTsBlockQueue getSharedTsBlockQueue() {
        return this.queue;
    }
}

