/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.exchange;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.mpp.execution.exchange.ISinkHandle;
import org.apache.iotdb.db.mpp.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.mpp.execution.exchange.SharedTsBlockQueue;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSinkHandle
implements ISinkHandle {
    private static final Logger logger = LoggerFactory.getLogger(LocalSinkHandle.class);
    private final TFragmentInstanceId remoteFragmentInstanceId;
    private final String remotePlanNodeId;
    private final TFragmentInstanceId localFragmentInstanceId;
    private final MPPDataExchangeManager.SinkHandleListener sinkHandleListener;
    private final SharedTsBlockQueue queue;
    private volatile ListenableFuture<Void> blocked = Futures.immediateFuture(null);
    private boolean aborted = false;

    public LocalSinkHandle(TFragmentInstanceId remoteFragmentInstanceId, String remotePlanNodeId, TFragmentInstanceId localFragmentInstanceId, SharedTsBlockQueue queue, MPPDataExchangeManager.SinkHandleListener sinkHandleListener) {
        this.remoteFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)remoteFragmentInstanceId);
        this.remotePlanNodeId = (String)Validate.notNull((Object)remotePlanNodeId);
        this.localFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)localFragmentInstanceId);
        this.sinkHandleListener = (MPPDataExchangeManager.SinkHandleListener)Validate.notNull((Object)sinkHandleListener);
        this.queue = (SharedTsBlockQueue)Validate.notNull((Object)queue);
        this.queue.setSinkHandle(this);
    }

    @Override
    public TFragmentInstanceId getLocalFragmentInstanceId() {
        return this.localFragmentInstanceId;
    }

    @Override
    public long getBufferRetainedSizeInBytes() {
        return this.queue.getBufferRetainedSizeInBytes();
    }

    @Override
    public synchronized ListenableFuture<?> isFull() {
        if (this.aborted) {
            throw new IllegalStateException("Sink handle is closed.");
        }
        return Futures.nonCancellationPropagating(this.blocked);
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            return this.queue.hasNoMoreTsBlocks() && this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndInvokeOnFinished() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            if (this.isFinished()) {
                LocalSinkHandle localSinkHandle = this;
                synchronized (localSinkHandle) {
                    this.sinkHandleListener.onFinish(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(List<TsBlock> tsBlocks) {
        Validate.notNull(tsBlocks, (String)"tsBlocks is null", (Object[])new Object[0]);
        Object object = this;
        synchronized (object) {
            if (this.aborted) {
                throw new IllegalStateException("Sink handle is aborted.");
            }
            if (!this.blocked.isDone()) {
                throw new IllegalStateException("Sink handle is blocked.");
            }
        }
        object = this.queue;
        synchronized (object) {
            if (this.queue.hasNoMoreTsBlocks()) {
                return;
            }
            logger.info("send TsBlocks. Size: {}", (Object)tsBlocks.size());
            LocalSinkHandle localSinkHandle = this;
            synchronized (localSinkHandle) {
                for (TsBlock tsBlock : tsBlocks) {
                    this.blocked = this.queue.add(tsBlock);
                }
            }
        }
    }

    @Override
    public synchronized void send(int partition, List<TsBlock> tsBlocks) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNoMoreTsBlocks() {
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            LocalSinkHandle localSinkHandle = this;
            synchronized (localSinkHandle) {
                logger.info("set noMoreTsBlocks.");
                if (this.aborted) {
                    return;
                }
                this.queue.setNoMoreTsBlocks(true);
                this.sinkHandleListener.onEndOfBlocks(this);
            }
        }
        this.checkAndInvokeOnFinished();
        logger.info("noMoreTsBlocks has been set.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        logger.info("Sink handle is being aborted.");
        SharedTsBlockQueue sharedTsBlockQueue = this.queue;
        synchronized (sharedTsBlockQueue) {
            LocalSinkHandle localSinkHandle = this;
            synchronized (localSinkHandle) {
                if (this.aborted) {
                    return;
                }
                this.aborted = true;
                this.queue.destroy();
                this.sinkHandleListener.onAborted(this);
            }
        }
        logger.info("Sink handle is aborted");
    }

    public TFragmentInstanceId getRemoteFragmentInstanceId() {
        return this.remoteFragmentInstanceId;
    }

    public String getRemotePlanNodeId() {
        return this.remotePlanNodeId;
    }

    SharedTsBlockQueue getSharedTsBlockQueue() {
        return this.queue;
    }
}

