/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.filter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.common.filter.FilterDeserializeUtil;
import org.apache.iotdb.db.mpp.common.filter.FilterTypes;
import org.apache.iotdb.db.mpp.common.filter.QueryFilter;
import org.apache.iotdb.db.mpp.plan.constant.FilterConstant;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionFilter
extends QueryFilter {
    private static final Logger logger = LoggerFactory.getLogger(FunctionFilter.class);

    public FunctionFilter(FilterConstant.FilterType filterType) {
        super(filterType);
    }

    public void reverseFunc() {
    }

    @Override
    public void addChildOperator(QueryFilter op) {
        logger.error("cannot add child to leaf FilterOperator, now it's FunctionOperator");
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        FilterTypes.Function.serialize(byteBuffer);
        super.serializeWithoutType(byteBuffer);
    }

    public static FunctionFilter deserialize(ByteBuffer byteBuffer) {
        int filterTypeIndex = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        int childSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<QueryFilter> queryFilters = new ArrayList<QueryFilter>();
        for (int i = 0; i < childSize; ++i) {
            queryFilters.add(FilterDeserializeUtil.deserialize(byteBuffer));
        }
        boolean isLeaf = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        boolean isSingle = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        PartialPath singlePath = null;
        if (isSingle) {
            singlePath = (PartialPath)PathDeserializeUtil.deserialize(byteBuffer);
        }
        int pathSetSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashSet<PartialPath> pathSet = new HashSet<PartialPath>();
        for (int i = 0; i < pathSetSize; ++i) {
            pathSet.add((PartialPath)PathDeserializeUtil.deserialize(byteBuffer));
        }
        FunctionFilter queryFilter = new FunctionFilter(FilterConstant.FilterType.values()[filterTypeIndex]);
        queryFilter.setChildren(queryFilters);
        queryFilter.setPathSet(pathSet);
        queryFilter.setSinglePath(singlePath);
        queryFilter.isLeaf = isLeaf;
        queryFilter.isSingle = isSingle;
        return queryFilter;
    }
}

