/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.counter;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.Traverser;

public class MeasurementGroupByLevelCounter
extends Traverser {
    private int groupByLevel;
    private Map<PartialPath, Integer> result = new HashMap<PartialPath, Integer>();
    private PartialPath path;

    public MeasurementGroupByLevelCounter(IMNode startNode, PartialPath path, IMTreeStore store, int groupByLevel) throws MetadataException {
        super(startNode, path, store);
        this.groupByLevel = groupByLevel;
        this.checkLevelAboveSG();
    }

    private void checkLevelAboveSG() {
        if (this.groupByLevel >= this.startLevel) {
            return;
        }
        int level = this.startLevel;
        for (IMNode parent = this.startNode.getParent(); parent != null; parent = parent.getParent()) {
            if (--level != this.groupByLevel) continue;
            this.path = parent.getPartialPath();
            this.result.putIfAbsent(this.path, 0);
            break;
        }
    }

    @Override
    protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
        if (level == this.groupByLevel) {
            this.path = node.getPartialPath();
            this.result.putIfAbsent(this.path, 0);
        }
        return false;
    }

    @Override
    protected boolean processFullMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
        if (level == this.groupByLevel) {
            this.path = node.getPartialPath();
            this.result.putIfAbsent(this.path, 0);
        }
        if (!node.isMeasurement()) {
            return false;
        }
        if (level >= this.groupByLevel) {
            this.result.put(this.path, this.result.get(this.path) + 1);
        }
        return true;
    }

    public Map<PartialPath, Integer> getResult() {
        return this.result;
    }

    public void setResult(Map<PartialPath, Integer> result) {
        this.result = result;
    }
}

