/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk;

import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTreeReleaseTaskManager {
    private static final Logger logger = LoggerFactory.getLogger(MTreeReleaseTaskManager.class);
    private static final String MTREE_RELEASE_THREAD_POOL_NAME = "MTree-release-task";
    private volatile ExecutorService releaseTaskExecutor;

    private MTreeReleaseTaskManager() {
    }

    public static MTreeReleaseTaskManager getInstance() {
        return MTreeReleaseTaskManagerHolder.INSTANCE;
    }

    public void init() {
        this.releaseTaskExecutor = IoTDBThreadPoolFactory.newCachedThreadPool((String)MTREE_RELEASE_THREAD_POOL_NAME);
    }

    public void clear() {
        if (this.releaseTaskExecutor != null) {
            this.releaseTaskExecutor.shutdown();
            while (!this.releaseTaskExecutor.isTerminated()) {
            }
            this.releaseTaskExecutor = null;
        }
    }

    public void submit(Runnable task) {
        this.releaseTaskExecutor.submit(() -> {
            try {
                task.run();
            }
            catch (Throwable throwable) {
                logger.error("Something wrong happened during MTree release.", throwable);
                throwable.printStackTrace();
                throw throwable;
            }
        });
    }

    private static class MTreeReleaseTaskManagerHolder {
        private static final MTreeReleaseTaskManager INSTANCE = new MTreeReleaseTaskManager();

        private MTreeReleaseTaskManagerHolder() {
        }
    }
}

