/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable.entry;

import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.idtable.IDiskSchemaManager;
import org.apache.iotdb.db.metadata.idtable.entry.DiskSchemaEntry;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.lastCache.container.ILastCacheContainer;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class SchemaEntry
implements ILastCacheContainer {
    private long schema;
    private long lastTime;
    private TsPrimitiveType lastValue;
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public SchemaEntry(TSDataType dataType) {
        TSEncoding encoding = EncodingInferenceUtils.getDefaultEncoding(dataType);
        CompressionType compressionType = TSFileDescriptor.getInstance().getConfig().getCompressor();
        this.schema |= (long)dataType.serialize();
        this.schema |= (long)encoding.serialize() << 8;
        this.schema |= (long)compressionType.serialize() << 16;
        this.lastTime = Long.MIN_VALUE;
    }

    public SchemaEntry(TSDataType dataType, TSEncoding encoding, CompressionType compressionType, long diskPos) {
        this.schema |= (long)dataType.serialize();
        this.schema |= (long)encoding.serialize() << 8;
        this.schema |= (long)compressionType.serialize() << 16;
        this.lastTime = Long.MIN_VALUE;
        this.schema |= diskPos << 25;
    }

    public SchemaEntry(TSDataType dataType, TSEncoding encoding, CompressionType compressionType, IDeviceID deviceID, PartialPath fullPath, boolean isAligned, IDiskSchemaManager IDiskSchemaManager2) {
        this.schema |= (long)dataType.serialize();
        this.schema |= (long)encoding.serialize() << 8;
        this.schema |= (long)compressionType.serialize() << 16;
        this.lastTime = Long.MIN_VALUE;
        if (config.isEnableIDTableLogFile()) {
            DiskSchemaEntry diskSchemaEntry = new DiskSchemaEntry(deviceID.toStringID(), fullPath.getFullPath(), fullPath.getMeasurement(), dataType.serialize(), encoding.serialize(), compressionType.serialize(), isAligned);
            this.schema |= IDiskSchemaManager2.serialize(diskSchemaEntry) << 25;
        }
    }

    public TSDataType getTSDataType() {
        return TSDataType.deserialize((byte)((byte)this.schema));
    }

    public TSEncoding getTSEncoding() {
        return TSEncoding.deserialize((byte)((byte)(this.schema >> 8)));
    }

    public CompressionType getCompressionType() {
        return CompressionType.deserialize((byte)((byte)(this.schema >> 16)));
    }

    public boolean isUsingTrigger() {
        return (this.schema >> 24 & 1L) == 1L;
    }

    public void setUsingTrigger() {
        this.schema |= 0x1000000L;
    }

    public void setUnUsingTrigger() {
        int mask = -16777217;
        this.schema &= (long)mask;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public Object getLastValue() {
        return this.lastValue;
    }

    @Override
    public TimeValuePair getCachedLast() {
        return this.lastValue == null ? null : new TimeValuePair(this.lastTime, this.lastValue);
    }

    @Override
    public void updateCachedLast(TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        if (timeValuePair == null || timeValuePair.getValue() == null) {
            return;
        }
        if (this.lastValue == null) {
            if (!highPriorityUpdate || latestFlushedTime <= timeValuePair.getTimestamp()) {
                this.lastTime = timeValuePair.getTimestamp();
                this.lastValue = timeValuePair.getValue();
            }
        } else if (timeValuePair.getTimestamp() > this.lastTime || timeValuePair.getTimestamp() == this.lastTime && highPriorityUpdate) {
            this.lastTime = timeValuePair.getTimestamp();
            this.lastValue = timeValuePair.getValue();
        }
    }

    @Override
    public void resetLastCache() {
        this.lastValue = null;
    }

    @Override
    public boolean isEmpty() {
        return this.lastValue == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaEntry)) {
            return false;
        }
        SchemaEntry that = (SchemaEntry)o;
        return this.schema == that.schema;
    }

    public int hashCode() {
        return Objects.hash(this.schema);
    }
}

