/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.localconfignode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;

public class LocalDataPartitionTable {
    private AtomicInteger dataRegionIdGenerator;
    private Map<PartialPath, List<DataRegionId>> table;

    private LocalDataPartitionTable() {
    }

    public static LocalDataPartitionTable getInstance() {
        return LocalDataPartitionTableHolder.INSTANCE;
    }

    public synchronized void init(Map<String, List<DataRegionId>> recoveredLocalDataRegionInfo) throws IllegalPathException {
        this.table = new ConcurrentHashMap<PartialPath, List<DataRegionId>>();
        this.dataRegionIdGenerator = new AtomicInteger(0);
        for (Map.Entry<String, List<DataRegionId>> entry : recoveredLocalDataRegionInfo.entrySet()) {
            String storageGroup = entry.getKey();
            CopyOnWriteArrayList<DataRegionId> dataRegionIdList = new CopyOnWriteArrayList<DataRegionId>();
            this.table.put(new PartialPath(storageGroup), dataRegionIdList);
            for (DataRegionId dataRegionId : recoveredLocalDataRegionInfo.get(storageGroup)) {
                dataRegionIdList.add(dataRegionId);
                if (dataRegionId.getId() < this.dataRegionIdGenerator.get()) continue;
                this.dataRegionIdGenerator.set(dataRegionId.getId() + 1);
            }
        }
    }

    public synchronized void clear() {
        if (this.table != null) {
            this.table.clear();
            this.table = null;
        }
        if (this.dataRegionIdGenerator != null) {
            this.dataRegionIdGenerator = null;
        }
    }

    public synchronized void putDataRegionId(PartialPath storageGroup, DataRegionId dataRegionId) {
        this.table.get(storageGroup).add(dataRegionId);
    }

    public synchronized void removeDataRegionId(PartialPath storageGroup, DataRegionId dataRegionId) {
        this.table.get(storageGroup).remove(dataRegionId);
    }

    public DataRegionId getDataRegionId(PartialPath storageGroup, PartialPath path) {
        if (!this.table.containsKey(storageGroup)) {
            return null;
        }
        return this.table.get(storageGroup).get(0);
    }

    public List<DataRegionId> getInvolvedDataRegionIds(PartialPath storageGroup, PartialPath pathPattern, boolean isPrefixMatch) {
        ArrayList<DataRegionId> result = new ArrayList<DataRegionId>();
        if (this.table.containsKey(storageGroup)) {
            result.addAll((Collection<DataRegionId>)this.table.get(storageGroup));
        }
        return result;
    }

    public List<DataRegionId> getDataRegionIdsByStorageGroup(PartialPath storageGroup) {
        return this.table.getOrDefault(storageGroup, Collections.emptyList());
    }

    public synchronized void setDataPartitionInfo(PartialPath storageGroup) {
        List<DataRegionId> dataRegionIdList = this.table.containsKey(storageGroup) ? this.table.get(storageGroup) : new CopyOnWriteArrayList<DataRegionId>();
        dataRegionIdList.add(this.generateDataRegionId());
        this.table.put(storageGroup, dataRegionIdList);
    }

    public synchronized List<DataRegionId> deleteStorageGroup(PartialPath storageGroup) {
        if (this.table.containsKey(storageGroup)) {
            return this.table.remove(storageGroup);
        }
        return Collections.emptyList();
    }

    private DataRegionId generateDataRegionId() {
        return new DataRegionId(this.dataRegionIdGenerator.getAndIncrement());
    }

    private static class LocalDataPartitionTableHolder {
        private static final LocalDataPartitionTable INSTANCE = new LocalDataPartitionTable();

        private LocalDataPartitionTableHolder() {
        }
    }
}

