/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.service;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.trigger.api.Trigger;
import org.apache.iotdb.db.engine.trigger.executor.TriggerExecutor;
import org.apache.iotdb.db.engine.trigger.service.TriggerClassLoader;
import org.apache.iotdb.db.engine.trigger.service.TriggerClassLoaderManager;
import org.apache.iotdb.db.engine.trigger.service.TriggerLogReader;
import org.apache.iotdb.db.engine.trigger.service.TriggerLogWriter;
import org.apache.iotdb.db.engine.trigger.service.TriggerRegistrationInformation;
import org.apache.iotdb.db.exception.TriggerExecutionException;
import org.apache.iotdb.db.exception.TriggerManagementException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.IDTableManager;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.StartTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.StopTriggerPlan;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerRegistrationService
implements IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerRegistrationService.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final String LOG_FILE_DIR = IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "trigger" + File.separator;
    private static final String LOG_FILE_NAME = LOG_FILE_DIR + "tlog.bin";
    private static final String TEMPORARY_LOG_FILE_NAME = LOG_FILE_NAME + ".tmp";
    private static final String LIB_ROOT = IoTDBDescriptor.getInstance().getConfig().getTriggerDir();
    private final ConcurrentHashMap<String, TriggerExecutor> executors = new ConcurrentHashMap();
    private TriggerLogWriter logWriter;

    private TriggerRegistrationService() {
    }

    public synchronized void register(CreateTriggerPlan plan) throws TriggerManagementException, TriggerExecutionException {
        IMNode imNode = this.tryGetMNode(plan);
        this.checkIfRegistered(plan, imNode);
        this.tryAppendRegistrationLog(plan);
        this.doRegister(plan, imNode);
    }

    private void checkIfRegistered(CreateTriggerPlan plan, IMNode imNode) throws TriggerManagementException {
        TriggerExecutor executor = imNode.getTriggerExecutor();
        if (executor != null) {
            TriggerRegistrationInformation information = executor.getRegistrationInformation();
            throw new TriggerManagementException(String.format("Failed to register trigger %s(%s), because a trigger %s(%s) has already been registered on the timeseries %s.", plan.getTriggerName(), plan.getClassName(), information.getTriggerName(), information.getClassName(), imNode.getFullPath()));
        }
        executor = this.executors.get(plan.getTriggerName());
        if (executor != null) {
            TriggerRegistrationInformation information = executor.getRegistrationInformation();
            throw new TriggerManagementException(information.getClassName().equals(plan.getClassName()) ? String.format("Failed to register trigger %s(%s), because a trigger with the same trigger name and the class name has already been registered.", plan.getTriggerName(), plan.getClassName()) : String.format("Failed to register trigger %s(%s), because a trigger %s(%s) with the same trigger name but a different class name has already been registered.", plan.getTriggerName(), plan.getClassName(), information.getTriggerName(), information.getClassName()));
        }
    }

    private IMNode tryGetMNode(CreateTriggerPlan plan) throws TriggerManagementException {
        try {
            IMNode imNode = IoTDB.schemaProcessor.getMNodeForTrigger(plan.getFullPath());
            if (imNode == null) {
                throw new TriggerManagementException(String.format("Path [%s] does not exist", plan.getFullPath().getFullPath()));
            }
            return imNode;
        }
        catch (MetadataException e) {
            throw new TriggerManagementException(e.getMessage(), e);
        }
    }

    private void tryAppendRegistrationLog(CreateTriggerPlan plan) throws TriggerManagementException {
        try {
            this.logWriter.write(plan);
        }
        catch (IOException e) {
            throw new TriggerManagementException(String.format("Failed to append trigger management operation log when registering trigger %s(%s), because %s", plan.getTriggerName(), plan.getClassName(), e));
        }
    }

    private void doRegister(CreateTriggerPlan plan, IMNode imNode) throws TriggerManagementException, TriggerExecutionException {
        TriggerExecutor executor;
        TriggerRegistrationInformation information = new TriggerRegistrationInformation(plan);
        TriggerClassLoader classLoader = TriggerClassLoaderManager.getInstance().register(plan.getClassName());
        try {
            executor = new TriggerExecutor(information, classLoader, imNode);
            executor.onCreate();
        }
        catch (TriggerExecutionException | TriggerManagementException e) {
            TriggerClassLoaderManager.getInstance().deregister(plan.getClassName());
            throw e;
        }
        this.executors.put(plan.getTriggerName(), executor);
        imNode.setTriggerExecutor(executor);
        if (CONFIG.isEnableIDTable()) {
            try {
                IDTable idTable = IDTableManager.getInstance().getIDTable(plan.getFullPath().getDevicePath());
                if (executor.getIMNode().isMeasurement()) {
                    idTable.registerTrigger(plan.getFullPath(), (IMeasurementMNode)imNode);
                }
            }
            catch (MetadataException e) {
                throw new TriggerManagementException(e.getMessage(), e);
            }
        }
    }

    public synchronized void deregister(DropTriggerPlan plan) throws TriggerManagementException {
        this.getTriggerExecutorWithExistenceCheck(plan.getTriggerName());
        this.tryAppendDeregistrationLog(plan);
        this.doDeregister(plan);
    }

    private TriggerExecutor getTriggerExecutorWithExistenceCheck(String triggerName) throws TriggerManagementException {
        TriggerExecutor executor = this.executors.get(triggerName);
        if (executor == null) {
            throw new TriggerManagementException(String.format("Trigger %s does not exist.", triggerName));
        }
        return executor;
    }

    private void tryAppendDeregistrationLog(DropTriggerPlan plan) throws TriggerManagementException {
        try {
            this.logWriter.write(plan);
        }
        catch (IOException e) {
            throw new TriggerManagementException(String.format("Failed to drop trigger %s because the operation plan was failed to log: %s", plan.getTriggerName(), e));
        }
    }

    private void doDeregister(DropTriggerPlan plan) throws TriggerManagementException {
        TriggerExecutor executor = this.executors.remove(plan.getTriggerName());
        IMNode imNode = executor.getIMNode();
        try {
            imNode.setTriggerExecutor(null);
            IoTDB.schemaProcessor.releaseMNodeAfterDropTrigger(imNode);
        }
        catch (MetadataException e) {
            throw new TriggerManagementException(e.getMessage(), e);
        }
        try {
            executor.onDrop();
        }
        catch (TriggerExecutionException e) {
            LOGGER.warn(e.getMessage(), (Throwable)((Object)e));
        }
        TriggerClassLoaderManager.getInstance().deregister(executor.getRegistrationInformation().getClassName());
        if (CONFIG.isEnableIDTable()) {
            try {
                PartialPath fullPath = executor.getIMNode().getPartialPath();
                IDTable idTable = IDTableManager.getInstance().getIDTable(fullPath.getDevicePath());
                if (executor.getIMNode().isMeasurement()) {
                    idTable.deregisterTrigger(fullPath, (IMeasurementMNode)executor.getIMNode());
                }
            }
            catch (MetadataException e) {
                throw new TriggerManagementException(e.getMessage(), e);
            }
        }
    }

    public void activate(StartTriggerPlan plan) throws TriggerManagementException, TriggerExecutionException {
        TriggerExecutor executor = this.getTriggerExecutorWithExistenceCheck(plan.getTriggerName());
        if (!executor.getRegistrationInformation().isStopped()) {
            throw new TriggerManagementException(String.format("Trigger %s has already been started.", plan.getTriggerName()));
        }
        try {
            this.logWriter.write(plan);
        }
        catch (IOException e) {
            throw new TriggerManagementException(String.format("Failed to append trigger management operation log when starting trigger %s, because %s", plan.getTriggerName(), e));
        }
        executor.onStart();
    }

    public void inactivate(StopTriggerPlan plan) throws TriggerManagementException {
        TriggerExecutor executor = this.getTriggerExecutorWithExistenceCheck(plan.getTriggerName());
        if (executor.getRegistrationInformation().isStopped()) {
            throw new TriggerManagementException(String.format("Trigger %s has already been stopped.", plan.getTriggerName()));
        }
        try {
            this.logWriter.write(plan);
        }
        catch (IOException e) {
            throw new TriggerManagementException(String.format("Failed to append trigger management operation log when stopping trigger %s, because %s", plan.getTriggerName(), e));
        }
        try {
            executor.onStop();
        }
        catch (TriggerExecutionException e) {
            LOGGER.warn("Failed to stop the executor of trigger {}({})", new Object[]{executor.getRegistrationInformation().getTriggerName(), executor.getRegistrationInformation().getClassName(), e});
        }
    }

    public QueryDataSet show() {
        ListDataSet dataSet = new ListDataSet(Arrays.asList(new PartialPath("trigger name", false), new PartialPath("status", false), new PartialPath("event", false), new PartialPath("path", false), new PartialPath("class name", false), new PartialPath("attributes", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT));
        this.putTriggerRecords(dataSet);
        return dataSet;
    }

    private void putTriggerRecords(ListDataSet dataSet) {
        for (TriggerExecutor executor : this.executors.values().toArray(new TriggerExecutor[0])) {
            TriggerRegistrationInformation information = executor.getRegistrationInformation();
            RowRecord rowRecord = new RowRecord(0L);
            rowRecord.addField((Object)Binary.valueOf((String)information.getTriggerName()), TSDataType.TEXT);
            rowRecord.addField((Object)Binary.valueOf((String)(information.isStopped() ? "stopped" : "started")), TSDataType.TEXT);
            rowRecord.addField((Object)Binary.valueOf((String)information.getEvent().toString()), TSDataType.TEXT);
            rowRecord.addField((Object)Binary.valueOf((String)information.getFullPath().getFullPath()), TSDataType.TEXT);
            rowRecord.addField((Object)Binary.valueOf((String)information.getClassName()), TSDataType.TEXT);
            rowRecord.addField((Object)Binary.valueOf((String)information.getAttributes().toString()), TSDataType.TEXT);
            dataSet.putRecord(rowRecord);
        }
    }

    public void start() throws StartupException {
        try {
            TriggerRegistrationService.makeDirIfNecessary(LIB_ROOT);
            TriggerRegistrationService.makeDirIfNecessary(LOG_FILE_DIR);
            this.doRecovery();
            this.logWriter = new TriggerLogWriter(LOG_FILE_NAME);
        }
        catch (Exception e) {
            throw new StartupException((Throwable)e);
        }
    }

    private static void makeDirIfNecessary(String dir) throws IOException {
        File file = SystemFileFactory.INSTANCE.getFile(dir);
        if (file.exists() && file.isDirectory()) {
            return;
        }
        FileUtils.forceMkdir((File)file);
    }

    private void doRecovery() throws IOException, TriggerManagementException {
        File temporaryLogFile = SystemFileFactory.INSTANCE.getFile(TEMPORARY_LOG_FILE_NAME);
        File logFile = SystemFileFactory.INSTANCE.getFile(LOG_FILE_NAME);
        if (temporaryLogFile.exists()) {
            if (logFile.exists()) {
                this.doRecoveryFromLogFile(logFile);
                FileUtils.deleteQuietly((File)temporaryLogFile);
            } else {
                this.doRecoveryFromLogFile(temporaryLogFile);
                FSFactoryProducer.getFSFactory().moveFile(temporaryLogFile, logFile);
            }
        } else if (logFile.exists()) {
            this.doRecoveryFromLogFile(logFile);
        }
    }

    private void doRecoveryFromLogFile(File logFile) throws IOException, TriggerManagementException {
        for (CreateTriggerPlan createTriggerPlan : this.recoverCreateTriggerPlans(logFile)) {
            try {
                this.doRegister(createTriggerPlan, this.tryGetMNode(createTriggerPlan));
                if (!createTriggerPlan.isStopped()) continue;
                this.executors.get(createTriggerPlan.getTriggerName()).onStop();
            }
            catch (TriggerExecutionException | TriggerManagementException e) {
                LOGGER.error("Failed to register the trigger {}({}) during recovering.", (Object)createTriggerPlan.getTriggerName(), (Object)createTriggerPlan.getClassName());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<CreateTriggerPlan> recoverCreateTriggerPlans(File logFile) throws IOException, TriggerManagementException {
        HashMap<String, CreateTriggerPlan> recoveredCreateTriggerPlans = new HashMap<String, CreateTriggerPlan>();
        try (TriggerLogReader reader = new TriggerLogReader(logFile);){
            block15: while (reader.hasNext()) {
                PhysicalPlan plan = reader.next();
                switch (plan.getOperatorType()) {
                    case CREATE_TRIGGER: {
                        recoveredCreateTriggerPlans.put(((CreateTriggerPlan)plan).getTriggerName(), (CreateTriggerPlan)plan);
                        continue block15;
                    }
                    case DROP_TRIGGER: {
                        recoveredCreateTriggerPlans.remove(((DropTriggerPlan)plan).getTriggerName());
                        continue block15;
                    }
                    case START_TRIGGER: {
                        CreateTriggerPlan createTriggerPlan = (CreateTriggerPlan)recoveredCreateTriggerPlans.get(((StartTriggerPlan)plan).getTriggerName());
                        if (createTriggerPlan == null) continue block15;
                        createTriggerPlan.markAsStarted();
                        continue block15;
                    }
                    case STOP_TRIGGER: {
                        CreateTriggerPlan createTriggerPlan = (CreateTriggerPlan)recoveredCreateTriggerPlans.get(((StopTriggerPlan)plan).getTriggerName());
                        if (createTriggerPlan == null) continue block15;
                        createTriggerPlan.markAsStopped();
                        continue block15;
                    }
                }
            }
            return recoveredCreateTriggerPlans.values();
            throw new TriggerManagementException("Unrecognized trigger management operation plan is recovered.");
        }
    }

    public void stop() {
        try {
            this.writeTemporaryLogFile();
            this.logWriter.close();
            this.logWriter.deleteLogFile();
            File temporaryLogFile = SystemFileFactory.INSTANCE.getFile(TEMPORARY_LOG_FILE_NAME);
            File logFile = SystemFileFactory.INSTANCE.getFile(LOG_FILE_NAME);
            FSFactoryProducer.getFSFactory().moveFile(temporaryLogFile, logFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeTemporaryLogFile() throws IOException {
        try (TriggerLogWriter temporaryLogWriter = new TriggerLogWriter(TEMPORARY_LOG_FILE_NAME);){
            for (TriggerExecutor executor : this.executors.values()) {
                TriggerRegistrationInformation information = executor.getRegistrationInformation();
                temporaryLogWriter.write(information.convertToCreateTriggerPlan());
                if (!information.isStopped()) continue;
                temporaryLogWriter.write(new StopTriggerPlan(information.getTriggerName()));
            }
        }
    }

    public void deregisterAll() throws TriggerManagementException {
        for (TriggerExecutor executor : this.executors.values()) {
            this.deregister(new DropTriggerPlan(executor.getRegistrationInformation().getTriggerName()));
        }
    }

    public Trigger getTriggerInstance(String triggerName) throws TriggerManagementException {
        return this.getTriggerExecutorWithExistenceCheck(triggerName).getTrigger();
    }

    public TriggerRegistrationInformation getRegistrationInformation(String triggerName) throws TriggerManagementException {
        return this.getTriggerExecutorWithExistenceCheck(triggerName).getRegistrationInformation();
    }

    public ServiceType getID() {
        return ServiceType.TRIGGER_REGISTRATION_SERVICE;
    }

    public int executorSize() {
        return this.executors.size();
    }

    public static TriggerRegistrationService getInstance() {
        return TriggerRegistrationServiceHelper.INSTANCE;
    }

    private static class TriggerRegistrationServiceHelper {
        private static final TriggerRegistrationService INSTANCE = new TriggerRegistrationService();

        private TriggerRegistrationServiceHelper() {
        }
    }
}

