/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.consensus.ConsensusFactory;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.statemachine.SchemaRegionStateMachine;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;

public class SchemaRegionConsensusImpl {
    private static final IoTDBConfig conf = IoTDBDescriptor.getInstance().getConfig();
    private static IConsensus INSTANCE = null;

    private SchemaRegionConsensusImpl() {
    }

    public static IConsensus getInstance() {
        return INSTANCE;
    }

    public static synchronized IConsensus setupAndGetInstance() {
        if (INSTANCE == null) {
            INSTANCE = (IConsensus)ConsensusFactory.getConsensusImpl((String)conf.getSchemaRegionConsensusProtocolClass(), (ConsensusConfig)ConsensusConfig.newBuilder().setThisNode(new TEndPoint(conf.getInternalIp(), conf.getSchemaRegionConsensusPort())).setStorageDir(conf.getSchemaRegionConsensusDir()).build(), gid -> new SchemaRegionStateMachine(SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)gid))).orElseThrow(() -> new IllegalArgumentException(String.format("Construct consensusImpl failed, Please check your consensus className %s", conf.getSchemaRegionConsensusProtocolClass())));
        }
        return INSTANCE;
    }
}

