/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service.thrift;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.client.SyncConfigNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.ConfigRequestType;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorReq;
import org.apache.iotdb.confignode.consensus.request.read.CountStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.read.GetDataNodeInfoReq;
import org.apache.iotdb.confignode.consensus.request.read.GetDataPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateDataPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetRegionInfoListReq;
import org.apache.iotdb.confignode.consensus.request.read.GetStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.RegisterDataNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.RemoveConfigNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.SetDataReplicationFactorReq;
import org.apache.iotdb.confignode.consensus.request.write.SetSchemaReplicationFactorReq;
import org.apache.iotdb.confignode.consensus.request.write.SetStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.SetTTLReq;
import org.apache.iotdb.confignode.consensus.request.write.SetTimePartitionIntervalReq;
import org.apache.iotdb.confignode.consensus.response.CountStorageGroupResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeInfosResp;
import org.apache.iotdb.confignode.consensus.response.PermissionInfoResp;
import org.apache.iotdb.confignode.consensus.response.RegionInfoListResp;
import org.apache.iotdb.confignode.consensus.response.StorageGroupSchemaResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerResp;
import org.apache.iotdb.confignode.rpc.thrift.TCheckUserPrivilegesReq;
import org.apache.iotdb.confignode.rpc.thrift.TClusterNodeInfos;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TCountStorageGroupResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeActiveReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionResp;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteStorageGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteStorageGroupsReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TLoginReq;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetStorageGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetTimePartitionIntervalReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchemaResp;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.consensus.common.response.ConsensusGenericResponse;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternTree;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeRPCServiceProcessor
implements IConfigNodeRPCService.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeRPCServiceProcessor.class);
    private final ConfigManager configManager;

    public ConfigNodeRPCServiceProcessor(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void close() throws IOException {
        this.configManager.close();
    }

    public ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    public TDataNodeRegisterResp registerDataNode(TDataNodeRegisterReq req) throws TException {
        RegisterDataNodeReq registerReq = new RegisterDataNodeReq(req.getDataNodeInfo());
        DataNodeConfigurationResp registerResp = (DataNodeConfigurationResp)this.configManager.registerDataNode(registerReq);
        TDataNodeRegisterResp resp = new TDataNodeRegisterResp();
        registerResp.convertToRpcDataNodeRegisterResp(resp);
        LOGGER.info("Execute RegisterDatanodeRequest {} with result {}", (Object)req, (Object)resp);
        return resp;
    }

    public TSStatus activeDataNode(TDataNodeActiveReq req) throws TException {
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TDataNodeInfoResp getDataNodeInfo(int dataNodeID) throws TException {
        GetDataNodeInfoReq queryReq = new GetDataNodeInfoReq(dataNodeID);
        DataNodeInfosResp queryResp = (DataNodeInfosResp)this.configManager.getDataNodeInfo(queryReq);
        TDataNodeInfoResp resp = new TDataNodeInfoResp();
        queryResp.convertToRpcDataNodeLocationResp(resp);
        return resp;
    }

    public TClusterNodeInfos getAllClusterNodeInfos() throws TException {
        return this.configManager.getAllClusterNodeInfos();
    }

    public TSStatus setStorageGroup(TSetStorageGroupReq req) throws TException {
        TStorageGroupSchema storageGroupSchema = req.getStorageGroup();
        if (!storageGroupSchema.isSetTTL()) {
            storageGroupSchema.setTTL(CommonDescriptor.getInstance().getConfig().getDefaultTTL());
        }
        if (!storageGroupSchema.isSetSchemaReplicationFactor()) {
            storageGroupSchema.setSchemaReplicationFactor(ConfigNodeDescriptor.getInstance().getConf().getSchemaReplicationFactor());
        }
        if (!storageGroupSchema.isSetDataReplicationFactor()) {
            storageGroupSchema.setDataReplicationFactor(ConfigNodeDescriptor.getInstance().getConf().getDataReplicationFactor());
        }
        if (!storageGroupSchema.isSetTimePartitionInterval()) {
            storageGroupSchema.setTimePartitionInterval(ConfigNodeDescriptor.getInstance().getConf().getTimePartitionInterval());
        }
        storageGroupSchema.setMaxSchemaRegionGroupCount(0);
        storageGroupSchema.setMaxDataRegionGroupCount(0);
        SetStorageGroupReq setReq = new SetStorageGroupReq(storageGroupSchema);
        TSStatus resp = this.configManager.setStorageGroup(setReq);
        LOGGER.info("Execute SetStorageGroupRequest {} with result {}", (Object)req, (Object)resp);
        return resp;
    }

    public TSStatus deleteStorageGroup(TDeleteStorageGroupReq tDeleteReq) throws TException {
        String prefixPath = tDeleteReq.getPrefixPath();
        return this.configManager.deleteStorageGroups(Collections.singletonList(prefixPath));
    }

    public TSStatus deleteStorageGroups(TDeleteStorageGroupsReq tDeleteReq) throws TException {
        List prefixList = tDeleteReq.getPrefixPathList();
        return this.configManager.deleteStorageGroups(prefixList);
    }

    public TSStatus setTTL(TSetTTLReq req) throws TException {
        return this.configManager.setTTL(new SetTTLReq(req.getStorageGroup(), req.getTTL()));
    }

    public TSStatus setSchemaReplicationFactor(TSetSchemaReplicationFactorReq req) throws TException {
        return this.configManager.setSchemaReplicationFactor(new SetSchemaReplicationFactorReq(req.getStorageGroup(), req.getSchemaReplicationFactor()));
    }

    public TSStatus setDataReplicationFactor(TSetDataReplicationFactorReq req) throws TException {
        return this.configManager.setDataReplicationFactor(new SetDataReplicationFactorReq(req.getStorageGroup(), req.getDataReplicationFactor()));
    }

    public TSStatus setTimePartitionInterval(TSetTimePartitionIntervalReq req) throws TException {
        return this.configManager.setTimePartitionInterval(new SetTimePartitionIntervalReq(req.getStorageGroup(), req.getTimePartitionInterval()));
    }

    public TCountStorageGroupResp countMatchedStorageGroups(List<String> storageGroupPathPattern) throws TException {
        CountStorageGroupResp countStorageGroupResp = (CountStorageGroupResp)this.configManager.countMatchedStorageGroups(new CountStorageGroupReq(storageGroupPathPattern));
        TCountStorageGroupResp resp = new TCountStorageGroupResp();
        countStorageGroupResp.convertToRPCCountStorageGroupResp(resp);
        return resp;
    }

    public TStorageGroupSchemaResp getMatchedStorageGroupSchemas(List<String> storageGroupPathPattern) throws TException {
        StorageGroupSchemaResp storageGroupSchemaResp = (StorageGroupSchemaResp)this.configManager.getMatchedStorageGroupSchemas(new GetStorageGroupReq(storageGroupPathPattern));
        TStorageGroupSchemaResp resp = new TStorageGroupSchemaResp();
        storageGroupSchemaResp.convertToRPCStorageGroupSchemaResp(resp);
        return resp;
    }

    public TSchemaPartitionResp getSchemaPartition(TSchemaPartitionReq req) throws TException {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        return this.configManager.getSchemaPartition(patternTree);
    }

    public TSchemaPartitionResp getOrCreateSchemaPartition(TSchemaPartitionReq req) throws TException {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        return this.configManager.getOrCreateSchemaPartition(patternTree);
    }

    public TSchemaNodeManagementResp getSchemaNodeManagementPartition(TSchemaNodeManagementReq req) throws TException {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        PartialPath partialPath = (PartialPath)patternTree.getAllPathPatterns().get(0);
        return this.configManager.getNodePathsPartition(partialPath, req.getLevel());
    }

    public TDataPartitionResp getDataPartition(TDataPartitionReq req) throws TException {
        GetDataPartitionReq getDataPartitionReq = new GetDataPartitionReq();
        getDataPartitionReq.convertFromRpcTDataPartitionReq(req);
        return this.configManager.getDataPartition(getDataPartitionReq);
    }

    public TDataPartitionResp getOrCreateDataPartition(TDataPartitionReq req) throws TException {
        GetOrCreateDataPartitionReq getOrCreateDataPartitionReq = new GetOrCreateDataPartitionReq();
        getOrCreateDataPartitionReq.convertFromRpcTDataPartitionReq(req);
        return this.configManager.getOrCreateDataPartition(getOrCreateDataPartitionReq);
    }

    public TSStatus operatePermission(TAuthorizerReq req) throws TException {
        if (req.getAuthorType() < 0 || req.getAuthorType() >= AuthorOperator.AuthorType.values().length) {
            throw new IndexOutOfBoundsException("Invalid Author Type ordinal");
        }
        AuthorReq plan = null;
        try {
            plan = new AuthorReq(ConfigRequestType.values()[req.getAuthorType() + ConfigRequestType.Author.ordinal() + 1], req.getUserName(), req.getRoleName(), req.getPassword(), req.getNewPassword(), req.getPermissions(), req.getNodeName());
        }
        catch (AuthException e) {
            LOGGER.error(e.getMessage());
        }
        return this.configManager.operatePermission(plan);
    }

    public TAuthorizerResp queryPermission(TAuthorizerReq req) throws TException {
        if (req.getAuthorType() < 0 || req.getAuthorType() >= AuthorOperator.AuthorType.values().length) {
            throw new IndexOutOfBoundsException("Invalid Author Type ordinal");
        }
        AuthorReq plan = null;
        try {
            plan = new AuthorReq(ConfigRequestType.values()[req.getAuthorType() + ConfigRequestType.Author.ordinal() + 1], req.getUserName(), req.getRoleName(), req.getPassword(), req.getNewPassword(), req.getPermissions(), req.getNodeName());
        }
        catch (AuthException e) {
            LOGGER.error(e.getMessage());
        }
        PermissionInfoResp dataSet = (PermissionInfoResp)this.configManager.queryPermission(plan);
        TAuthorizerResp resp = new TAuthorizerResp(dataSet.getStatus());
        resp.setAuthorizerInfo(dataSet.getPermissionInfo());
        return resp;
    }

    public TPermissionInfoResp login(TLoginReq req) throws TException {
        return this.configManager.login(req.getUserrname(), req.getPassword());
    }

    public TPermissionInfoResp checkUserPrivileges(TCheckUserPrivilegesReq req) throws TException {
        return this.configManager.checkUserPrivileges(req.getUsername(), req.getPaths(), req.getPermission());
    }

    public TConfigNodeRegisterResp registerConfigNode(TConfigNodeRegisterReq req) throws TException {
        TConfigNodeRegisterResp resp = this.configManager.registerConfigNode(req);
        LOGGER.info("Execute RegisterConfigNodeRequest {} with result {}", (Object)req, (Object)resp);
        return resp;
    }

    public TSStatus addConsensusGroup(TConfigNodeRegisterResp registerResp) {
        return this.configManager.addConsensusGroup(registerResp.getConfigNodeList());
    }

    public TSStatus removeConfigNode(TConfigNodeLocation configNodeLocation) throws TException {
        RemoveConfigNodeReq removeConfigNodeReq = new RemoveConfigNodeReq(configNodeLocation);
        TSStatus status = this.configManager.removeConfigNode(removeConfigNodeReq);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            status = SyncConfigNodeClientPool.getInstance().stopConfigNode(configNodeLocation);
        }
        LOGGER.info("Execute RemoveConfigNodeRequest {} with result {}", (Object)configNodeLocation, (Object)status);
        return status;
    }

    public TSStatus stopConfigNode(TConfigNodeLocation configNodeLocation) throws TException {
        if (!this.configManager.getNodeManager().getOnlineConfigNodes().contains(configNodeLocation)) {
            return new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode()).setMessage("Stop ConfigNode failed because the ConfigNode not in current Cluster.");
        }
        ConsensusGroupId groupId = this.configManager.getConsensusManager().getConsensusGroupId();
        ConsensusGenericResponse resp = this.configManager.getConsensusManager().getConsensusImpl().removeConsensusGroup(groupId);
        if (!resp.isSuccess()) {
            return new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode()).setMessage("Stop ConfigNode failed because remove ConsensusGroup failed.");
        }
        new Thread(() -> {
            try {
                ConfigNode.getInstance().stop();
                System.exit(0);
            }
            catch (IOException e) {
                LOGGER.error("Meet error when stop ConfigNode!", (Throwable)e);
            }
        }).start();
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Stop ConfigNode success.");
    }

    public TSStatus createFunction(TCreateFunctionReq req) {
        return this.configManager.createFunction(req.getUdfName(), req.getClassName(), req.getUris());
    }

    public TSStatus dropFunction(TDropFunctionReq req) throws TException {
        return this.configManager.dropFunction(req.getUdfName());
    }

    public TSStatus flush(TFlushReq req) throws TException {
        List<PartialPath> noExistSg;
        if (req.storageGroups != null && !(noExistSg = this.configManager.checkStorageGroupExist(PartialPath.fromStringList((List)req.storageGroups))).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            noExistSg.forEach(storageGroup -> sb.append(storageGroup.getFullPath()).append(","));
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.STORAGE_GROUP_NOT_EXIST, (String)("storageGroup " + sb.subSequence(0, sb.length() - 1) + " does not exist"));
        }
        return this.configManager.flush(req);
    }

    public TShowRegionResp showRegion(TShowRegionReq showRegionReq) throws TException {
        GetRegionInfoListReq getRegionsinfoReq = new GetRegionInfoListReq(showRegionReq.getConsensusGroupType());
        RegionInfoListResp dataSet = (RegionInfoListResp)this.configManager.showRegion(getRegionsinfoReq);
        TShowRegionResp showRegionResp = new TShowRegionResp();
        showRegionResp.setStatus(dataSet.getStatus());
        showRegionResp.setRegionInfoList(dataSet.getRegionInfoList());
        return showRegionResp;
    }

    public long getConfigNodeHeartBeat(long timestamp) throws TException {
        return timestamp;
    }

    public void handleClientExit() {
    }
}

