/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service;

import java.io.IOException;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.JMXService;
import org.apache.iotdb.commons.service.RegisterManager;
import org.apache.iotdb.commons.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.commons.udf.service.UDFExecutableManager;
import org.apache.iotdb.commons.udf.service.UDFRegistrationService;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.ConfigNodeRemoveCheck;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.service.ConfigNodeCommandLine;
import org.apache.iotdb.confignode.service.ConfigNodeMBean;
import org.apache.iotdb.confignode.service.thrift.ConfigNodeRPCService;
import org.apache.iotdb.confignode.service.thrift.ConfigNodeRPCServiceProcessor;
import org.apache.iotdb.db.service.metrics.MetricsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNode
implements ConfigNodeMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNode.class);
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.confignode.service", "type", "ConfigNode");
    private final RegisterManager registerManager = new RegisterManager();
    private ConfigNodeRPCService configNodeRPCService;
    private ConfigNodeRPCServiceProcessor configNodeRPCServiceProcessor;
    private ConfigManager configManager;

    private ConfigNode() {
    }

    private void initConfigManager() {
        try {
            this.configManager = new ConfigManager();
        }
        catch (IOException e) {
            LOGGER.error("Can't start ConfigNode consensus group!", (Throwable)e);
            try {
                this.stop();
            }
            catch (IOException e2) {
                LOGGER.error("Meet error when stop ConfigNode!", (Throwable)e);
            }
            System.exit(-1);
        }
        this.configNodeRPCService = new ConfigNodeRPCService();
        this.configNodeRPCServiceProcessor = new ConfigNodeRPCServiceProcessor(this.configManager);
    }

    public static void main(String[] args) {
        new ConfigNodeCommandLine().doMain(args);
    }

    private void setUp() throws StartupException, IOException {
        LOGGER.info("Setting up {}...", (Object)"IoTDB-ConfigNode");
        this.initConfigManager();
        this.registerManager.register((IService)new JMXService());
        JMXService.registerMBean((Object)this, (String)this.mbeanName);
        this.registerManager.register((IService)MetricsService.getInstance());
        this.configManager.addMetrics();
        this.registerUdfServices();
        this.configNodeRPCService.initSyncedServiceImpl(this.configNodeRPCServiceProcessor);
        this.registerManager.register((IService)this.configNodeRPCService);
        LOGGER.info("Init rpc server success");
        MetricsService.getInstance().startAllReporter();
    }

    private void registerUdfServices() throws StartupException {
        ConfigNodeConfig configNodeConfig = ConfigNodeDescriptor.getInstance().getConf();
        this.registerManager.register((IService)UDFExecutableManager.setupAndGetInstance((String)configNodeConfig.getTemporaryLibDir(), (String)configNodeConfig.getUdfLibDir()));
        this.registerManager.register((IService)UDFClassLoaderManager.setupAndGetInstance((String)configNodeConfig.getUdfLibDir()));
        this.registerManager.register((IService)UDFRegistrationService.setupAndGetInstance((String)configNodeConfig.getSystemUdfDir()));
    }

    public void active() {
        try {
            this.setUp();
        }
        catch (IOException | StartupException e) {
            LOGGER.error("Meet error while starting up.", e);
            try {
                this.deactivate();
            }
            catch (IOException e2) {
                LOGGER.error("Meet error when stop ConfigNode!", e);
            }
            return;
        }
        LOGGER.info("{} has successfully started and joined the cluster.", (Object)"IoTDB-ConfigNode");
    }

    public void deactivate() throws IOException {
        LOGGER.info("Deactivating {}...", (Object)"IoTDB-ConfigNode");
        this.registerManager.deregisterAll();
        JMXService.deregisterMBean((String)this.mbeanName);
        if (this.configManager != null) {
            this.configManager.close();
        }
        LOGGER.info("{} is deactivated.", (Object)"IoTDB-ConfigNode");
    }

    public void stop() throws IOException {
        this.deactivate();
    }

    public void doRemoveNode(String[] args) throws IOException {
        LOGGER.info("Starting to remove {}...", (Object)"IoTDB-ConfigNode");
        if (args.length != 3) {
            LOGGER.info("Usage: -r <ip>:<rpcPort>");
            return;
        }
        try {
            TEndPoint endPoint = NodeUrlUtils.parseTEndPointUrl((String)args[2]);
            TConfigNodeLocation removeConfigNodeLocation = ConfigNodeRemoveCheck.getInstance().removeCheck(endPoint);
            if (removeConfigNodeLocation == null) {
                LOGGER.error("The ConfigNode not in the Cluster.");
                return;
            }
            ConfigNodeRemoveCheck.getInstance().removeConfigNode(removeConfigNodeLocation);
        }
        catch (BadNodeUrlException e) {
            LOGGER.warn("No ConfigNodes need to be removed.", (Throwable)e);
        }
        LOGGER.info("{} is removed.", (Object)"IoTDB-ConfigNode");
    }

    public static ConfigNode getInstance() {
        return ConfigNodeHolder.INSTANCE;
    }

    private static class ConfigNodeHolder {
        private static final ConfigNode INSTANCE = new ConfigNode();

        private ConfigNodeHolder() {
        }
    }
}

