/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.AddConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.DeleteStorageGroupProcedure;
import org.apache.iotdb.confignode.procedure.store.IProcedureFactory;

public class ProcedureFactory
implements IProcedureFactory {
    @Override
    public Procedure create(ByteBuffer buffer) throws IOException {
        StateMachineProcedure procedure;
        int typeNum = buffer.getInt();
        if (typeNum >= ProcedureType.values().length) {
            throw new IOException("unrecognized log type " + typeNum);
        }
        ProcedureType type = ProcedureType.values()[typeNum];
        switch (type) {
            case DELETE_STORAGE_GROUP_PROCEDURE: {
                procedure = new DeleteStorageGroupProcedure();
                break;
            }
            case ADD_CONFIG_NODE_PROCEDURE: {
                procedure = new AddConfigNodeProcedure();
                break;
            }
            default: {
                throw new IOException("unknown Procedure type: " + typeNum);
            }
        }
        ((Procedure)procedure).deserialize(buffer);
        return procedure;
    }

    public static ProcedureType getProcedureType(Procedure procedure) {
        if (procedure instanceof DeleteStorageGroupProcedure) {
            return ProcedureType.DELETE_STORAGE_GROUP_PROCEDURE;
        }
        if (procedure instanceof AddConfigNodeProcedure) {
            return ProcedureType.ADD_CONFIG_NODE_PROCEDURE;
        }
        return null;
    }

    public static ProcedureFactory getInstance() {
        return ProcedureFactoryHolder.INSTANCE;
    }

    private static class ProcedureFactoryHolder {
        private static final ProcedureFactory INSTANCE = new ProcedureFactory();

        private ProcedureFactoryHolder() {
        }
    }

    public static enum ProcedureType {
        DELETE_STORAGE_GROUP_PROCEDURE,
        ADD_CONFIG_NODE_PROCEDURE;

    }
}

