/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.env;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeInfo;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.SyncConfigNodeClientPool;
import org.apache.iotdb.confignode.client.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.consensus.request.write.ApplyConfigNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.DeleteStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.PreDeleteStorageGroupReq;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.procedure.scheduler.ProcedureScheduler;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateCacheReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeProcedureEnv {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigNodeProcedureEnv.class);
    private final ReentrantLock addConfigNodeLock = new ReentrantLock();
    private final ConfigManager configManager;
    private final ProcedureScheduler scheduler;
    private static boolean skipForTest = false;
    private static boolean invalidCacheResult = true;

    public static void setSkipForTest(boolean skipForTest) {
        ConfigNodeProcedureEnv.skipForTest = skipForTest;
    }

    public static void setInvalidCacheResult(boolean result) {
        invalidCacheResult = result;
    }

    public ConfigNodeProcedureEnv(ConfigManager configManager, ProcedureScheduler scheduler) {
        this.configManager = configManager;
        this.scheduler = scheduler;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public TSStatus deleteConfig(String name) {
        DeleteStorageGroupReq deleteStorageGroupReq = new DeleteStorageGroupReq(name);
        return this.configManager.getClusterSchemaManager().deleteStorageGroup(deleteStorageGroupReq);
    }

    public void preDelete(PreDeleteStorageGroupReq.PreDeleteType preDeleteType, String deleteSgName) {
        this.configManager.getPartitionManager().preDeleteStorageGroup(deleteSgName, preDeleteType);
    }

    public boolean invalidateCache(String storageGroupName) throws IOException, TException {
        if (skipForTest) {
            return invalidCacheResult;
        }
        List<TDataNodeInfo> allDataNodes = this.configManager.getNodeManager().getOnlineDataNodes(-1);
        TInvalidateCacheReq invalidateCacheReq = new TInvalidateCacheReq();
        invalidateCacheReq.setStorageGroup(true);
        invalidateCacheReq.setFullPath(storageGroupName);
        for (TDataNodeInfo dataNodeInfo : allDataNodes) {
            TSStatus invalidateSchemaStatus = SyncDataNodeClientPool.getInstance().invalidateSchemaCache(dataNodeInfo.getLocation().getInternalEndPoint(), invalidateCacheReq);
            TSStatus invalidatePartitionStatus = SyncDataNodeClientPool.getInstance().invalidatePartitionCache(dataNodeInfo.getLocation().getInternalEndPoint(), invalidateCacheReq);
            if (this.verifySucceed(invalidatePartitionStatus, invalidateSchemaStatus)) continue;
            LOG.error("Invalidate cache failed, invalidate partition cache status is {}\uff0c invalidate schema cache status is {}", (Object)invalidatePartitionStatus, (Object)invalidateSchemaStatus);
            return false;
        }
        return true;
    }

    public boolean verifySucceed(TSStatus ... status) {
        return Arrays.stream(status).allMatch(tsStatus -> tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public void addConsensusGroup(TConfigNodeLocation tConfigNodeLocation) {
        ArrayList<TConfigNodeLocation> configNodeLocations = new ArrayList<TConfigNodeLocation>();
        configNodeLocations.addAll(this.configManager.getNodeManager().getOnlineConfigNodes());
        configNodeLocations.add(tConfigNodeLocation);
        SyncConfigNodeClientPool.getInstance().addConsensusGroup(tConfigNodeLocation.getInternalEndPoint(), configNodeLocations);
    }

    public void addPeer(TConfigNodeLocation tConfigNodeLocation) {
        this.configManager.getNodeManager().applyConfigNode(new ApplyConfigNodeReq(tConfigNodeLocation));
    }

    public ReentrantLock getAddConfigNodeLock() {
        return this.addConfigNodeLock;
    }

    public ProcedureScheduler getScheduler() {
        return this.scheduler;
    }
}

